/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinData;
import cds.aladin.Calib;
import cds.aladin.CanvasColorMap;
import cds.aladin.Command;
import cds.aladin.Configuration;
import cds.aladin.ContourAlgorithm;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.FootprintBean;
import cds.aladin.Fov;
import cds.aladin.Glu;
import cds.aladin.Legende;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.MySplitPane;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanBGCat;
import cds.aladin.PlanBGCube;
import cds.aladin.PlanBGProgen;
import cds.aladin.PlanBGRgb;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanContour;
import cds.aladin.PlanField;
import cds.aladin.PlanFilter;
import cds.aladin.PlanFolder;
import cds.aladin.PlanFov;
import cds.aladin.PlanFree;
import cds.aladin.PlanHealpix;
import cds.aladin.PlanHealpixAlgo;
import cds.aladin.PlanHealpixDMap;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageAlgo;
import cds.aladin.PlanImageBlink;
import cds.aladin.PlanImageColor;
import cds.aladin.PlanImageCube;
import cds.aladin.PlanImageCubeRGB;
import cds.aladin.PlanImageFitsCmp;
import cds.aladin.PlanImageHuge;
import cds.aladin.PlanImageMosaic;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanImageResamp;
import cds.aladin.PlanMoc;
import cds.aladin.PlanMocAlgo;
import cds.aladin.PlanMocColl;
import cds.aladin.PlanMocGen;
import cds.aladin.PlanMultiCCD;
import cds.aladin.PlanSTMoc;
import cds.aladin.PlanSTMocAlgo;
import cds.aladin.PlanSTMocGen;
import cds.aladin.PlanTMoc;
import cds.aladin.PlanTMocAlgo;
import cds.aladin.PlanTMocGen;
import cds.aladin.PlanTool;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.ResourceNode;
import cds.aladin.ScrollbarStack;
import cds.aladin.Select;
import cds.aladin.Server;
import cds.aladin.ServerFile;
import cds.aladin.SliderPanel;
import cds.aladin.Source;
import cds.aladin.SourceFootprint;
import cds.aladin.SourcePhot;
import cds.aladin.SourceStat;
import cds.aladin.SourceTag;
import cds.aladin.Tag;
import cds.aladin.TapManager;
import cds.aladin.Tok;
import cds.aladin.TreeObjDir;
import cds.aladin.ViewSimple;
import cds.aladin.Zoom;
import cds.aladin.stc.STCObj;
import cds.allsky.TabRgb;
import cds.moc.Healpix;
import cds.moc.Moc;
import cds.moc.SMoc;
import cds.moc.STMoc;
import cds.moc.TMoc;
import cds.tools.Astrodate;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Calque
extends JPanel
implements Runnable {
    int FIRSTBLOC = 25;
    int BLOC = 50;
    Aladin aladin;
    Select select;
    SliderPanel slider;
    Zoom zoom;
    protected Plan[] plan;
    int maxPlan = 0;
    int current;
    int runme_n = -1;
    ScrollbarStack scroll;
    protected int reticleMode;
    protected int gridMode = 1;
    protected boolean flagOverlay;
    protected boolean flagHpxPolar;
    protected boolean flagAutoDist;
    protected boolean flagSimbad;
    protected boolean flagVizierSED;
    protected boolean flagTip;
    protected Fov[] curFov;
    Projection fovProj;
    protected Fov[] cutoutFov = null;
    protected int overlayFlag;
    protected static final int SCALE = 1;
    protected static final int LABEL = 2;
    protected static final int SIZE = 4;
    protected static final int GRID = 8;
    protected static final int NE = 16;
    protected static final int RETICLE = 32;
    protected static final int TARGET = 64;
    protected static final int PIXEL = 128;
    protected static final int HPXGRID = 256;
    protected static final int COLORMAP = 512;
    protected static final int CONST = 1024;
    private static final String[] OVERLAYFLAG = new String[]{"scale", "label", "size", "grid", "NE", "reticle", "target", "pixel", "HPXgrid", "colormap", "const"};
    private static final int[] OVERLAYFLAGVAL = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    private JPanel haut;
    protected Object pile = new Object();
    private boolean flagFirstAutoDist = true;
    private boolean flagFirstSimbad = true;
    private boolean flagFirstVizierSED = true;
    protected boolean taggedSrc = false;
    private Obj oNewobj = null;
    private boolean memoClinDoeil = false;
    private Vector<Obj> memoVselobj = null;
    private Source[] memoSrcList = null;
    static final int COLIMG = 256;
    static final int CALIB = 512;
    static final int TRUEIMG = 1024;
    static final int IMG = 2048;
    static final int SELECTED = 4096;
    Plan planRotCenter = null;
    static final String DMAPGLU = "getDMap";
    private String _target;
    private String _radius;
    private String _file;
    private MyInputStream _in;
    private Plan _firstPlan;
    private String _label;
    private Obj _o;
    private boolean lock;
    private final Object lockObj = new Object();

    public int getOverlayFlag() {
        return this.overlayFlag;
    }

    public boolean hasScale() {
        return (this.overlayFlag & 1) == 1;
    }

    public boolean hasLabel() {
        return (this.overlayFlag & 2) == 2;
    }

    public boolean hasSize() {
        return (this.overlayFlag & 4) == 4;
    }

    public boolean hasGrid() {
        return (this.overlayFlag & 8) == 8;
    }

    public boolean hasNE() {
        return (this.overlayFlag & 0x10) == 16;
    }

    public boolean hasReticle() {
        return (this.overlayFlag & 0x20) == 32;
    }

    public boolean hasTarget() {
        return (this.overlayFlag & 0x40) == 64;
    }

    public boolean hasPixel() {
        return (this.overlayFlag & 0x80) == 128;
    }

    public boolean hasHpxGrid() {
        return (this.overlayFlag & 0x100) == 256;
    }

    public boolean hasColormap() {
        return (this.overlayFlag & 0x200) == 512;
    }

    public boolean hasConst() {
        return (this.overlayFlag & 0x400) == 1024;
    }

    public boolean setOverlayFlag(String name, boolean flag) {
        int i = Util.indexInArrayOf(name, OVERLAYFLAG, true);
        if (i < 0) {
            return false;
        }
        this.overlayFlag = flag ? (this.overlayFlag |= OVERLAYFLAGVAL[i]) : (this.overlayFlag &= ~OVERLAYFLAGVAL[i]);
        return true;
    }

    public void setOverlayList(String names) throws Exception {
        int mode = 0;
        if (names.length() > 1) {
            if (names.charAt(0) == '+') {
                mode = 1;
                names = names.substring(1);
            } else if (names.charAt(0) == '-') {
                mode = -1;
                names = names.substring(1);
            }
        }
        if (mode == 0) {
            this.overlayFlag = 0;
            mode = 1;
        }
        int mask = 0;
        Tok tok = new Tok(names, ",");
        while (tok.hasMoreTokens()) {
            String name = tok.nextToken().trim();
            int i = Util.indexInArrayOf(name, OVERLAYFLAG, true);
            if (i >= 0) {
                mask |= OVERLAYFLAGVAL[i];
                continue;
            }
            throw new Exception("overlay parameter unknown [" + name + "]");
        }
        this.overlayFlag = mode == 1 ? (this.overlayFlag |= mask) : (this.overlayFlag &= ~mask);
        if (this.aladin.view != null) {
            this.aladin.view.showRainbow(this.hasColormap());
        }
    }

    public String getOverlayList() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < OVERLAYFLAG.length; ++i) {
            if ((this.overlayFlag & OVERLAYFLAGVAL[i]) != OVERLAYFLAGVAL[i]) continue;
            if (s.length() > 0) {
                s.append(',');
            }
            s.append(OVERLAYFLAG[i]);
        }
        return s.toString();
    }

    protected void createChaine() {
    }

    protected Calque() {
    }

    protected Calque(Aladin aladin) {
        this.aladin = aladin;
        this.select = new Select(aladin);
        this.slider = new SliderPanel(aladin);
        this.zoom = new Zoom(aladin);
        this.scroll = new ScrollbarStack(aladin, 1, this.FIRSTBLOC - 1, 1, 0, this.FIRSTBLOC);
        this.reallocPlan();
        this.flagOverlay = true;
        this.reticleMode = aladin.configuration.get(Configuration.RETICLE) != null ? 2 : 1;
        this.flagTip = aladin.configuration.get(Configuration.TOOLTIP) != null;
        this.flagAutoDist = aladin.configuration.getAutoDist();
        this.flagSimbad = aladin.configuration.getSimbadFlag();
        this.flagVizierSED = aladin.configuration.getVizierSEDFlag();
        try {
            this.setOverlayList("label,scale,size,NE,target,reticle,target,pixel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.haut = new JPanel(new BorderLayout(10, 10));
        this.haut.add((Component)this.select, "Center");
        this.haut.add((Component)this.slider, "South");
        this.haut.setBackground(aladin.getBackground());
        JPanel bas = new JPanel(new BorderLayout(10, 10));
        bas.setBackground(aladin.getBackground());
        bas.add((Component)this.zoom, "Center");
        this.setLayout(new BorderLayout());
        MySplitPane splitH = new MySplitPane(aladin, 0, this.haut, bas, 1);
        bas.setMinimumSize(new Dimension(100, 100));
        bas.setPreferredSize(new Dimension(100, aladin.getZoomViewHeight()));
        splitH.setResizeWeight(1.0);
        aladin.splitZoomHeight = splitH;
        this.setBackground(aladin.getBackground());
        this.add((Component)splitH, "Center");
    }

    protected boolean scrollAdjustement() {
        boolean hideScroll;
        if (this.aladin.isFullScreen()) {
            return false;
        }
        int lastPlan = this.scroll.getLastVisiblePlan();
        if (lastPlan == -1) {
            return false;
        }
        boolean bl = hideScroll = !this.scroll.getRequired();
        if (this.scroll.isShowing() && hideScroll) {
            this.haut.remove(this.scroll);
            this.validate();
            return true;
        }
        if (!this.scroll.isShowing() && !hideScroll) {
            this.haut.add((Component)this.scroll, "East");
            this.validate();
            return true;
        }
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Select.frMax + 95 + 16, 200);
    }

    protected int getNbPlan() {
        return this.plan.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Plan getPlanByHashCode(int hashCode) {
        Object object = this.pile;
        synchronized (object) {
            for (int i = 0; i < this.plan.length; ++i) {
                if (this.plan[i].hashCode() != hashCode) continue;
                return this.plan[i];
            }
        }
        return null;
    }

    public Plan getPlan(int index) {
        try {
            return this.plan[index];
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected Plan[] getPlans() {
        return this.getPlans(false);
    }

    protected Plan[] getPlans(boolean flagReverse) {
        Plan[] p = new Plan[this.plan.length];
        System.arraycopy(this.plan, 0, p, 0, this.plan.length);
        if (flagReverse) {
            int i = 0;
            for (int j = p.length - 1; i < j; ++i, --j) {
                Plan p1 = p[i];
                p[i] = p[j];
                p[j] = p1;
            }
        }
        return p;
    }

    private Plan getMyScopeFolder(Plan p) {
        return this.getMyScopeFolder(this.plan, p);
    }

    protected Plan getMyScopeFolder(Plan[] allPlan, Plan p) {
        int nivCherche = p.folder - 1;
        for (int i = this.getIndex(p) - 1; nivCherche >= 0 && i >= 0; --i) {
            if (allPlan[i].type != 11) continue;
            if (((PlanFolder)allPlan[i]).localScope && allPlan[i].folder == nivCherche) {
                return allPlan[i];
            }
            --nivCherche;
        }
        return null;
    }

    protected Plan getFolder(Plan f) {
        if (f.type == 11) {
            return f;
        }
        int n = this.getIndex(f);
        for (int i = n - 1; i >= 0; --i) {
            if (this.plan[i].type != 11 || this.plan[i].folder >= f.folder) continue;
            return this.plan[i];
        }
        return null;
    }

    protected Plan[] getFolderPlan(Plan f) {
        return this.getFolderPlan(f, true);
    }

    protected Plan[] getFolderPlan(Plan f, boolean all) {
        int i;
        if (f.type != 11) {
            return null;
        }
        Vector<Plan> v = new Vector<Plan>(10);
        int n = f.folder;
        boolean trouve = false;
        for (i = 0; i < this.plan.length; ++i) {
            Plan pc = this.plan[i];
            if (!trouve) {
                trouve = pc == f;
                continue;
            }
            if (pc.folder <= n) break;
            if (!all && pc.folder != f.folder + 1) continue;
            v.addElement(pc);
        }
        Plan[] p = new Plan[v.size()];
        Enumeration e = v.elements();
        i = 0;
        while (e.hasMoreElements()) {
            p[i++] = (Plan)e.nextElement();
        }
        return p;
    }

    protected boolean isCollapsed(Plan f) {
        int i;
        if (f.type != 11) {
            return false;
        }
        Plan[] plan = this.getPlans();
        for (i = 0; i < plan.length && plan[i] != f; ++i) {
        }
        if (i >= plan.length - 1) {
            return false;
        }
        return plan[i + 1].collapse;
    }

    protected void setActiveFolder(Plan f, boolean flag) {
        Plan[] p = this.getFolderPlan(f);
        for (int i = p.length - 1; i >= 0; --i) {
            p[i].setActivated(flag);
        }
        f.setActivated(flag);
        this.repaintAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reallocPlan() {
        int n;
        int bloc = this.maxPlan > 0 ? this.BLOC : this.FIRSTBLOC;
        Object object = this.pile;
        synchronized (object) {
            Plan[] newP = new Plan[this.maxPlan + bloc];
            if (this.maxPlan > 0) {
                System.arraycopy(this.plan, 0, newP, bloc, this.maxPlan);
                n = this.scroll.getValue() + bloc;
            } else {
                n = bloc;
            }
            for (int i = 0; i < bloc; ++i) {
                newP[i] = new PlanFree(this.aladin);
            }
            this.plan = newP;
            this.maxPlan += bloc;
            if (SwingUtilities.isEventDispatchThread()) {
                this.scroll.setValues(n - 1, 1, 0, this.maxPlan);
            } else {
                final int[] param = new int[]{n};
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Calque.this.scroll.setValues(param[0] - 1, 1, 0, Calque.this.maxPlan);
                    }
                });
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinitPlan() {
        this.maxPlan = this.FIRSTBLOC;
        Object object = this.pile;
        synchronized (object) {
            Plan[] newP = new Plan[this.maxPlan];
            for (int i = 0; i < this.maxPlan; ++i) {
                newP[i] = new PlanFree(this.aladin);
            }
            this.plan = newP;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.scroll.setValues(this.maxPlan - 1, 1, 0, this.maxPlan);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Calque.this.scroll.setValues(Calque.this.maxPlan - 1, 1, 0, Calque.this.maxPlan);
                }
            });
        }
        this.taggedSrc = false;
    }

    protected int getNbSelectedPlans() {
        int n = 0;
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (plan[i].type == 0 || !plan[i].flagOk || !plan[i].selected) continue;
            ++n;
        }
        return n;
    }

    protected int getNbUsedPlans() {
        int n = 0;
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (plan[i].type == 0 || !plan[i].flagOk) continue;
            ++n;
        }
        return n;
    }

    protected double getFps() {
        Plan[] plan = this.getPlans();
        double fps = 0.0;
        int n = 0;
        for (int i = 0; i < plan.length; ++i) {
            double x;
            if (plan[i].type != 16 || !plan[i].flagOk || !plan[i].active) continue;
            try {
                x = ((PlanBG)plan[i]).getFps();
            }
            catch (Exception e) {
                continue;
            }
            if (x <= 0.0) continue;
            fps += x;
            ++n;
        }
        return fps / (double)n;
    }

    protected int getNbPlanImg() {
        return this.getNbPlanImg(true);
    }

    protected int getNbPlanImg(boolean withBG) {
        int n = 0;
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (!plan[i].isReady()) continue;
            if (plan[i].isImage()) {
                ++n;
            }
            if (!withBG || plan[i].type != 16) continue;
            ++n;
        }
        return n;
    }

    protected int getNbPlanByClass(Class<?> c) {
        int n = 0;
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (!c.isInstance(plan[i]) || !plan[i].flagOk) continue;
            ++n;
        }
        return n;
    }

    protected int getNbPlanImgSelected() {
        int n = 0;
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (!(plan[i] instanceof PlanImage) || !plan[i].flagOk || plan[i] instanceof PlanBG || !plan[i].selected) continue;
            ++n;
        }
        return n;
    }

    protected int getNbPlanTranspImg() {
        int n = 0;
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (!(plan[i] instanceof PlanImage) || !plan[i].flagOk || !plan[i].hasCanBeTranspState()) continue;
            ++n;
        }
        return n;
    }

    protected int getNbPlanCat() {
        int n = 0;
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (!plan[i].isCatalog() || !plan[i].flagOk) continue;
            ++n;
        }
        return n;
    }

    protected int getNbRedo() {
        int n = 0;
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (!plan[i].isRedoable()) continue;
            ++n;
        }
        return n;
    }

    protected int getNbPlanCatTime() {
        int n = 0;
        for (Plan p : this.getPlans()) {
            if (!p.isCatalog() || !p.flagOk || !p.isCatalogTime()) continue;
            ++n;
        }
        return n;
    }

    protected int resumeTimeStackIndex() {
        Plan[] plan = this.getPlans();
        int index = 0;
        for (int i = plan.length - 1; i >= 0; --i) {
            Plan p = plan[i];
            if (!p.flagOk || !p.active || !(p instanceof PlanTMoc)) continue;
            p.timeStackIndex = index++;
        }
        return index;
    }

    protected boolean hasSelectableObjects() {
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            Plan p = plan[i];
            if (!p.flagOk || !p.active || p instanceof PlanContour || p instanceof PlanMoc || !p.hasObj() && !p.hasSources()) continue;
            return true;
        }
        return false;
    }

    protected int getNbPlanTool() {
        int n = 0;
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (!(plan[i] instanceof PlanTool) || !plan[i].flagOk) continue;
            ++n;
        }
        return n;
    }

    protected int getNbPlanMoc() {
        int n = 0;
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (!plan[i].isMoc() || !plan[i].flagOk) continue;
            ++n;
        }
        return n;
    }

    protected int getNbPlanImgBG() {
        int n = 0;
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (plan[i].type != 16 || !plan[i].flagOk) continue;
            ++n;
        }
        return n;
    }

    protected int getNbPlanImgHiPS4RGB() {
        int n = 0;
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (plan[i].type != 16 || !plan[i].flagOk || !Aladin.BETA && !((PlanBG)plan[i]).isLocalAllSky() || !((PlanBG)plan[i]).canbeTruePixels()) continue;
            ++n;
        }
        return n;
    }

    protected long getNbSrc() {
        long n = 0L;
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (!plan[i].isCatalog() || !plan[i].flagOk) continue;
            n += (long)plan[i].getCounts();
        }
        return n;
    }

    protected double[] getGlobalTimeRange() {
        double jdmin = Double.NaN;
        double jdmax = Double.NaN;
        for (Plan p : this.getPlans()) {
            if (!p.flagOk || !p.isTime() || !p.active) continue;
            double[] t = null;
            try {
                t = p.getTimeRange();
                if (Double.isNaN(jdmin) || t[0] < jdmin) {
                    jdmin = t[0];
                }
                if (!Double.isNaN(jdmax) && !(t[1] > jdmax)) continue;
                jdmax = t[1];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new double[]{jdmin, jdmax};
    }

    protected void setReticle(int mode) {
        this.reticleMode = mode;
        this.setOverlayFlag("reticle", mode > 0);
    }

    protected void setGrid(int mode) {
        this.gridMode = mode;
        this.setGrid(mode != 0, false);
    }

    protected int getGrid() {
        return this.gridMode;
    }

    protected void setConstellation(boolean mode) {
        this.setOverlayFlag("const", mode);
    }

    protected void setGrid(boolean flag, boolean verbose) {
        if (flag == !this.hasGrid()) {
            this.switchGrid(verbose);
        }
    }

    protected void switchGrid(boolean verbose) {
        if (!this.hasGrid()) {
            this.setOverlayFlag("grid", true);
            if (verbose) {
                this.aladin.console.printCommand("grid on");
            }
        } else {
            this.setOverlayFlag("grid", false);
            if (verbose) {
                this.aladin.console.printCommand("grid off");
            }
        }
        this.repaintAll();
    }

    protected void setOverlay(boolean flag) {
        this.flagOverlay = flag;
    }

    protected void setAutoDist(boolean flag) {
        if (this.flagFirstAutoDist && flag && this.aladin.configuration.isHelp()) {
            this.aladin.configuration.showHelpIfOk("HAUTODIST");
            this.flagFirstAutoDist = false;
        }
        this.flagAutoDist = flag;
    }

    protected void setSimbad(boolean flag) {
        if (this.flagFirstSimbad && flag && this.aladin.configuration.isHelp()) {
            this.aladin.configuration.showHelpIfOk("HFINGER");
            this.flagFirstSimbad = false;
        }
        this.flagSimbad = flag;
    }

    protected void setVizierSED(boolean flag) {
        if (this.flagFirstVizierSED && flag && this.aladin.configuration.isHelp()) {
            this.aladin.configuration.showHelpIfOk("HFINGERVIZIERSED");
            this.flagFirstVizierSED = false;
        }
        this.flagVizierSED = flag;
    }

    protected Plan contains(Coord coo) {
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            Plan p = plan[i];
            if (!p.flagOk || !(p instanceof PlanImage) || !p.contains(coo)) continue;
            return p;
        }
        return null;
    }

    protected boolean dejaCharge(int type, String objet, String param) {
        return this.dejaCharge(type, objet, param, null);
    }

    protected boolean dejaCharge(int type, String objet, String param, String other) {
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (!plan[i].theSame(type, objet, param, other)) continue;
            return true;
        }
        return false;
    }

    protected boolean isFreeX(Plan p) {
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (plan[i] == p || plan[i].type == 0 || (!(plan[i] instanceof PlanBG) || !((PlanBG)plan[i]).flagOk) && !plan[i].isSync()) continue;
            return false;
        }
        return true;
    }

    protected boolean hasImage(Plan p) {
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (plan[i] == p || !plan[i].isSync() || !plan[i].isImage() && plan[i].type != 16) continue;
            return true;
        }
        return false;
    }

    protected boolean isFree() {
        return this.getNbPlans(false) == 0;
    }

    protected int getNbPlans(boolean onlyReady) {
        int n = 0;
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (plan[i].type == 0 || onlyReady && !plan[i].flagOk) continue;
            ++n;
        }
        return n;
    }

    protected String getBlinkingInfo() {
        StringBuffer s = new StringBuffer();
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            Plan p = plan[i];
            if (p.type == 0 || (p.flagOk || p.error != null) && !p.flagProcessing && (p.type != 15 || !((PlanImageHuge)p).isExtracting)) continue;
            if (s.length() > 0) {
                s.append(", ");
            }
            s.append(p.label);
        }
        return s.toString();
    }

    protected boolean isBlinking() {
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            Plan p = plan[i];
            if (p.type == 0) continue;
            if (!p.flagOk && p.error == null) {
                return true;
            }
            if (p.flagProcessing) {
                return true;
            }
            if (p.type != 15 || !((PlanImageHuge)p).isExtracting) continue;
            return true;
        }
        return false;
    }

    protected boolean waitingFirst() {
        boolean rep = false;
        for (int i = 0; i < this.plan.length; ++i) {
            Plan p = this.plan[i];
            if (p.type == 0) continue;
            rep = true;
            if (!p.flagOk) continue;
            return false;
        }
        return rep;
    }

    protected void Free() {
        int n = this.getFirstSelected();
        if (n < 0) {
            return;
        }
        this.Free(n);
    }

    protected void Free(Plan p) {
        this.Free(this.getIndex(p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Free(int n) {
        if (n != -1) {
            final int[] param = new int[]{n};
            Object object = this.pile;
            synchronized (object) {
                this.plan[n].Free();
                if (SwingUtilities.isEventDispatchThread()) {
                    this.scroll.rm(param[0]);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Calque.this.scroll.rm(param[0]);
                        }
                    });
                }
            }
        }
        this.repaintAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void FreeAll() {
        Aladin.makeCursor(this, 1);
        this.aladin.view.freeAll();
        Object object = this.pile;
        synchronized (object) {
            for (int i = 0; i < this.plan.length; ++i) {
                this.plan[i].Free();
            }
            this.reinitPlan();
        }
        this.repaintAll();
        Aladin.makeCursor(this, 0);
    }

    protected void setActivatedSet(boolean flagShow) {
        if (flagShow) {
            int nb = 0;
            for (int i = 0; i < this.plan.length; ++i) {
                if (!this.plan[i].selected || !this.plan[i].isImage() || !this.canBeRef(this.plan[i])) continue;
                ++nb;
            }
            if (nb > this.aladin.view.getNbView()) {
                this.aladin.view.setModeView(nb <= 3 ? 3 : (nb <= 4 ? 4 : (nb <= 9 ? 9 : 16)));
            }
        }
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].selected) continue;
            if (!flagShow || !this.plan[i].isImage()) {
                this.plan[i].setActivated(flagShow);
                continue;
            }
            this.showPlan(this.plan[i], true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void FreeEmpty() {
        Object object = this.pile;
        synchronized (object) {
            for (int i = this.plan.length - 1; i >= 0; --i) {
                if (!this.plan[i].isEmpty() || !this.plan[i].Free()) continue;
                this.scroll.rm(i);
                for (int j = i; j > 1; --j) {
                    this.plan[j] = this.plan[j - 1];
                }
                ++i;
                this.plan[0] = new PlanFree(this.aladin);
            }
        }
        this.aladin.view.findBestDefault();
        this.repaintAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void FreeSetExcept(boolean verbose) {
        Object object = this.pile;
        synchronized (object) {
            int j;
            int i;
            for (i = this.plan.length - 1; i >= 0; --i) {
                if (this.plan[i].type != 11) continue;
                Plan[] p = this.getFolderPlan(this.plan[i]);
                boolean flagAllUnselected = false;
                for (j = 0; j < p.length; ++j) {
                    if (!p[j].selected) continue;
                    flagAllUnselected = false;
                    break;
                }
                this.plan[j].selected = !flagAllUnselected;
            }
            for (i = this.plan.length - 1; i >= 0; --i) {
                if (this.plan[i].selected || this.plan[i].type == 0) continue;
                if (verbose) {
                    this.aladin.console.printCommand("rm " + Tok.quote(this.plan[i].label));
                }
                if (!this.plan[i].Free()) continue;
                this.scroll.rm(i);
                for (j = i; j > 1; --j) {
                    this.plan[j] = this.plan[j - 1];
                }
                ++i;
                this.plan[0] = new PlanFree(this.aladin);
            }
        }
        if (this.isFree()) {
            this.zoom.zoomView.free();
        }
        this.aladin.view.findBestDefault();
        this.repaintAll();
        this.aladin.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void FreeSet(boolean verbose) {
        Object object = this.pile;
        synchronized (object) {
            int j;
            int i;
            for (i = this.plan.length - 1; i >= 0; --i) {
                if (!this.plan[i].selected || this.plan[i].type != 11) continue;
                Plan[] p = this.getFolderPlan(this.plan[i]);
                for (j = 0; j < p.length; ++j) {
                    p[j].selected = true;
                }
            }
            boolean askInterrupt = false;
            if (!Aladin.NOGUI && verbose) {
                int nb = 0;
                for (Plan p : this.plan) {
                    if (!p.selected || !p.isSimpleCatalog()) continue;
                    ++nb;
                }
                askInterrupt = nb == 1;
            }
            for (i = this.plan.length - 1; i >= 0; --i) {
                if (!this.plan[i].selected || this.plan[i].type == 0) continue;
                if (verbose) {
                    this.aladin.console.printCommand("rm " + Tok.quote(this.plan[i].label));
                }
                if (!this.plan[i].Free(askInterrupt)) continue;
                this.scroll.rm(i);
                for (j = i; j > 1; --j) {
                    this.plan[j] = this.plan[j - 1];
                }
                ++i;
                this.plan[0] = new PlanFree(this.aladin);
            }
        }
        if (this.isFree()) {
            this.zoom.zoomView.free();
        }
        this.aladin.view.findBestDefault();
        this.repaintAll();
        this.aladin.gc();
    }

    protected boolean hasTaggedSrc() {
        if (!this.taggedSrc) {
            return false;
        }
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (!plan[i].isCatalog() || !plan[i].flagOk) continue;
            Iterator<Obj> it = plan[i].iterator();
            while (it.hasNext()) {
                Source s;
                Obj o = it.next();
                if (!o.asSource() || !(s = (Source)o).isTagged()) continue;
                return true;
            }
        }
        return false;
    }

    protected void selectAllObjectInPlans() {
        this.selectAllObject(1);
    }

    protected void selectAllObject(int mode) {
        this.aladin.view.deSelect();
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].hasObj() || !this.plan[i].flagOk || !this.plan[i].active || mode != 0 && mode != 2 && !this.plan[i].selected) continue;
            this.aladin.view.selectAllInPlanWithoutFree(this.plan[i], mode == 2 ? 1 : 0);
        }
        if (Aladin.PLASTIC_SUPPORT && this.aladin.getMessagingMgr().isRegistered()) {
            try {
                this.aladin.getMessagingMgr().sendSelectObjectsMsg();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.aladin.view.repaintAll();
        this.aladin.mesure.mcanvas.repaint();
    }

    protected void untag() {
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].isCatalog() || !this.plan[i].flagOk) continue;
            Iterator<Obj> it = this.plan[i].iterator();
            while (it.hasNext()) {
                Obj o = it.next();
                if (!o.asSource()) continue;
                Source s = (Source)o;
                s.setTag(false);
            }
        }
        this.repaintAll();
        this.aladin.mesure.mcanvas.repaint();
    }

    protected Vector<Obj> setMultiSelect(ViewSimple v, RectangleD r) {
        Vector<Obj> res = new Vector<Obj>(5000);
        Plan folder = this.getMyScopeFolder(v.pref);
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].active || !this.plan[i].hasObj() || this.plan[i].type == 10 || folder != this.getMyScopeFolder(this.plan[i])) continue;
            Enumeration<Obj> e = this.plan[i].setMultiSelect(v, r).elements();
            while (e.hasMoreElements()) {
                res.addElement(e.nextElement());
            }
        }
        return res;
    }

    protected Vector<Obj> getObjWith(ViewSimple v, double x, double y) {
        Vector<Obj> res = new Vector<Obj>(500, 500);
        Plan folder = this.getMyScopeFolder(v.pref);
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            Plan p = plan[i];
            if (!p.active || p instanceof PlanTool && !p.isCatalog() && p.type != 9 && p.type != 10 || folder != this.getMyScopeFolder(p)) continue;
            Enumeration<Obj> e = p.getObjWith(v, x, y).elements();
            while (e.hasMoreElements()) {
                res.addElement(e.nextElement());
            }
        }
        return res;
    }

    protected Source[] getSources(String[] oid) {
        int i;
        if (oid == null) {
            return new Source[0];
        }
        Vector<Source> v = new Vector<Source>(500, 500);
        Plan[] plan = this.getPlans();
        for (int k = 0; k < plan.length; ++k) {
            Plan p = plan[k];
            if (p.isSimpleCatalog() || p.pcat == null) continue;
            block1: for (i = 0; i < oid.length; ++i) {
                Iterator<Obj> it = p.iterator();
                while (it.hasNext()) {
                    Source s;
                    String cOid;
                    Obj o = it.next();
                    if (!o.asSource() || (cOid = (s = (Source)o).getOID()) == null || !cOid.equals(oid[i])) continue;
                    v.addElement(s);
                    continue block1;
                }
            }
        }
        Source[] s = new Source[v.size()];
        i = 0;
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            s[i++] = (Source)e.nextElement();
        }
        return s;
    }

    protected void resumeFrame() {
        int frame = this.aladin.localisation.getFrame();
        this.aladin.command.setDrawMode(frame == 11 ? Command.DRAWXY : Command.DRAWRADEC);
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (plan[i].type == 0) continue;
            if (plan[i].type == 9) {
                ((PlanTool)plan[i]).setIdAgain();
            }
            if (!(plan[i] instanceof PlanBG) || !Projection.isOk(plan[i].projd) || plan[i].projd.frame == ((PlanBG)plan[i]).getCurrentFrameDrawing()) continue;
            plan[i].projd.frame = ((PlanBG)plan[i]).getCurrentFrameDrawing();
            plan[i].syncProjLocal();
            plan[i].resetProj();
        }
        Server srv = this.aladin.dialog.server[this.aladin.dialog.current];
        if (srv.target != null && srv.tree != null) {
            srv.target.setText("");
        }
        this.aladin.dialog.adjustParameters();
        this.aladin.dialog.resume();
        if (this.aladin.frameInfo != null) {
            this.aladin.frameInfo.initTarget();
        }
        this.aladin.view.grilAgain();
        this.aladin.view.repaintAll();
    }

    protected void resumePixel() {
        if (this.aladin.calque.freeUnusedPixelsOrigin()) {
            this.aladin.gc();
        }
    }

    protected void setObjet(Obj newobj) {
        if (newobj == this.oNewobj) {
            return;
        }
        PlanTool pc = this.selectPlanTool();
        if (newobj instanceof SourceTag) {
            pc.pcat.insertSource((Source)newobj);
        } else {
            pc.pcat.setObjet(newobj);
        }
        this.oNewobj = newobj;
    }

    protected boolean delObjet(Obj obj) {
        Plan p = ((Position)obj).plan;
        if (!p.active || p.pcat == null) {
            return false;
        }
        return p.pcat.delObjet(obj);
    }

    protected void majPlanFlag() {
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (plan[i].type == 0) continue;
            if (this.canBeRef(plan[i])) {
                plan[i].ref = this.aladin.view.isUsed(plan[i]);
            }
            if (plan[i].type == 12) continue;
            plan[i].setActivated();
        }
    }

    protected boolean freeUnusedPixelsOrigin() {
        boolean rep = false;
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (plan[i].type != 1 && !(plan[i] instanceof PlanBG) || !plan[i].flagOk) continue;
            if (!plan[i].active) {
                rep |= ((PlanImage)plan[i]).pixelsOriginIntoCache(true);
                continue;
            }
            if (!((PlanImage)plan[i]).pixelsOriginFromDisk()) continue;
            rep |= ((PlanImage)plan[i]).pixelsOriginIntoCache(false);
        }
        return rep;
    }

    protected boolean canBeRef(Plan p) {
        if (p == null) {
            return false;
        }
        if (p.hasXYorig) {
            return true;
        }
        if (p.hasNoPos) {
            return false;
        }
        return p.isImage() || p.type == 16 || p.isPlanBGOverlay() || p.isCatalog() || p.isTool();
    }

    protected boolean setPlanRef(Plan p) {
        return this.setPlanRef(p, this.aladin.view.getLastNumView(p));
    }

    protected boolean setPlanRef(Plan p, int nview) {
        if (nview < 0 || !this.canBeRef(p)) {
            return false;
        }
        p.ref = true;
        this.aladin.view.setSelect(nview);
        this.aladin.view.setPlanRef(nview, p);
        this.selectPlan(p);
        return true;
    }

    protected boolean setPlanRefOnSameTarget(PlanBG p) {
        int nview = this.aladin.view.getLastNumView(p);
        if (nview < 0 || !this.canBeRef(p)) {
            return false;
        }
        ViewSimple v = this.aladin.view.viewSimple[nview];
        if (v.isFree() || !Projection.isOk(v.pref.projd)) {
            return this.setPlanRef(p, nview);
        }
        Coord c = v.getProj().getProjCenter();
        Aladin.trace(4, "Calque.setPlanRefOnSameTarget() sur " + c);
        double z = v.zoom;
        double fct = 1.0;
        try {
            fct = p.projd.getPixResAlpha() / v.getProj().getPixResAlpha();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setPlanRef(p, nview);
        v.getProj().setProjCenter(c.al, c.del);
        v.newView(1);
        v.setZoomRaDec(z * fct, c.al, c.del);
        return true;
    }

    protected boolean setPlanRef(int n) {
        return this.setPlanRef(n, this.aladin.view.getLastNumView(this.plan[n]));
    }

    protected boolean setPlanRef(int n, int nview) {
        return this.setPlanRef(this.getPlan(n), nview);
    }

    protected void selectPlan(Plan p) {
        this.unSelectAllPlan();
        if (p != null) {
            p.selected = true;
            p.setActivated(true);
        }
        this.select.showSelectedPlan();
    }

    protected void selectPlan(String id) {
        for (Plan p : this.plan) {
            if (p.isFree() || !id.equals(p.id) && !id.startsWith(p.label)) continue;
            this.unSelectAllPlan();
            p.selected = true;
            p.setActivated(true);
            this.select.showSelectedPlan();
            this.aladin.calque.repaintAll();
            return;
        }
    }

    protected void selectPlanUnderMouse(Plan p) {
        this.unSelectUnderMouse();
        if (p != null) {
            p.underMouse = true;
        }
    }

    protected void unSelectUnderMouse() {
        for (int i = 0; i < this.plan.length; ++i) {
            this.plan[i].underMouse = false;
        }
    }

    protected void unSelectAllPlan() {
        for (int i = 0; i < this.plan.length; ++i) {
            this.plan[i].underMouse = false;
            this.plan[i].selected = false;
        }
    }

    protected void rename(Plan p, String name) {
        p.setLabel(name);
        this.repaintAll();
    }

    protected void showPlan(Plan p) {
        this.showPlan(p, true);
    }

    protected void showPlan(Plan p, boolean flagPaint) {
        if (this.select.canBeNewRef(p)) {
            if (this.setPlanRef(p)) {
                this.aladin.view.newView();
            }
        } else if (!this.aladin.view.tryToShow(p)) {
            p.setActivated(true);
        }
        if (flagPaint) {
            this.repaintAll();
        }
    }

    protected void switchOffBGOver(Plan p) {
        Plan[] plan = this.getPlans();
        int n = this.getIndex(p);
        for (int i = n - 1; i >= 0; --i) {
            Plan pc = plan[i];
            if (!pc.flagOk || !(pc instanceof PlanBG) || pc.isOverlay()) continue;
            pc.setActivated(false);
        }
        p.setActivated(true);
    }

    protected boolean hasClinDoeil() {
        return this.memoClinDoeil;
    }

    protected void resetClinDoeil() {
        this.memoClinDoeil = false;
        this.memoVselobj = null;
        this.memoSrcList = null;
    }

    protected void clinDoeil() {
        if (!this.memoClinDoeil) {
            this.memoVselobj = (Vector)this.aladin.view.vselobj.clone();
            int nbSrc = this.aladin.mesure.getNbSrc();
            this.memoSrcList = new Source[nbSrc];
            this.aladin.mesure.memoSrcList(this.memoSrcList);
        }
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            Plan pc = plan[i];
            if (!pc.flagOk || pc.ref) continue;
            if (this.memoClinDoeil) {
                pc.setActivated(pc.memoClinDoeil);
                continue;
            }
            pc.memoClinDoeil = pc.active;
            pc.setActivated(false);
        }
        if (this.memoClinDoeil) {
            this.aladin.view.vselobj = this.memoVselobj;
            for (Obj o : this.memoVselobj) {
                o.setSelect(true);
            }
            this.aladin.mesure.restoreSrcList(this.memoSrcList, this.memoSrcList.length);
        }
        this.memoClinDoeil = !this.memoClinDoeil;
        this.aladin.view.newView();
    }

    protected void activateAll() {
        boolean atLeastOne = false;
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (!plan[i].flagOk) continue;
            atLeastOne |= plan[i].setActivated(true);
        }
        if (atLeastOne) {
            this.aladin.view.newView();
        }
    }

    protected int getIndex(Plan p) {
        return this.getIndex(this.plan, p);
    }

    protected int getIndex(Plan[] plan, Plan p) {
        if (p == null) {
            return -1;
        }
        for (int i = 0; i < plan.length; ++i) {
            if (plan[i].type == 0 || plan[i] != p) continue;
            return i;
        }
        return -1;
    }

    protected int getIndexPlan(String mask) {
        return this.getIndexPlan(mask, 0);
    }

    protected int getIndexPlan(String mask, int mode) {
        for (int i = 0; i < this.plan.length; ++i) {
            if ((mode != 0 || !Util.matchMask(mask, this.plan[i].label)) && (mode != 1 || !mask.equals(this.plan[i].label))) continue;
            return i;
        }
        return -1;
    }

    public Plan getPlan(String mask) {
        return this.getPlan(mask, 0);
    }

    protected Plan getPlan(String mask, int mode) {
        int i = this.getIndexPlan(mask, mode);
        return i == -1 ? null : this.plan[i];
    }

    protected Vector getPlans(String mask) {
        Vector<Plan> v = null;
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            Plan pc = plan[i];
            if (pc.hasError() || !Util.matchMask(mask, pc.label)) continue;
            if (v == null) {
                v = new Vector<Plan>(plan.length);
            }
            v.addElement(pc);
        }
        return v;
    }

    private boolean isSpecialType(int type) {
        return type > 255;
    }

    private int getSpecialType(Plan p) {
        int type = 0;
        if (p instanceof PlanImage) {
            type |= 0x800;
        }
        if (p instanceof PlanImageRGB) {
            type |= 0x100;
        }
        if (!p.hasNoReduction()) {
            type |= 0x200;
        }
        if (p.hasAvailablePixels()) {
            type |= 0x400;
        }
        if (p.selected) {
            type |= 0x1000;
        }
        return type;
    }

    protected void resetDrawFastDetection() {
        for (Plan p : this.plan) {
            if (!(p instanceof PlanBG)) continue;
            ((PlanBG)p).resetDrawFastDetection();
        }
    }

    public Color isLoaded(String hipsId) {
        for (int i = 0; i < this.plan.length; ++i) {
            if (this.plan[i].isFree()) continue;
            if (this.plan[i].id != null && this.plan[i].id.startsWith(hipsId)) {
                return this.plan[i].c;
            }
            if (this.plan[i].label != null && this.plan[i].label.startsWith(hipsId)) {
                return this.plan[i].c;
            }
            if (this.plan[i].id == null || !("CDS/" + this.plan[i].id).startsWith(hipsId)) continue;
            return this.plan[i].c;
        }
        return null;
    }

    protected Vector<Plan> getPlansMoc() {
        Vector<Plan> v = null;
        for (int i = 0; i < this.plan.length; ++i) {
            Plan pc = this.plan[i];
            if (pc.hasError() || !pc.isMoc()) continue;
            if (v == null) {
                v = new Vector<Plan>(this.plan.length);
            }
            v.addElement(pc);
        }
        return v;
    }

    protected Vector<Plan> getPlans(int type) {
        Vector<Plan> v = null;
        for (int i = 0; i < this.plan.length; ++i) {
            int planSpecialType;
            Plan pc = this.plan[i];
            if (pc.hasError() || pc.isFree() || (!this.isSpecialType(type) ? (type != 1 ? (type != 8 ? pc.type != type : !pc.isSimpleCatalog()) : pc.type != 1 && pc.type != 15 && pc.type != 5 && pc.type != 7 && pc.type != 6) : (type & (planSpecialType = this.getSpecialType(pc))) == 0)) continue;
            if (v == null) {
                v = new Vector<Plan>(this.plan.length);
            }
            v.addElement(pc);
        }
        return v;
    }

    protected Vector<Plan> getPlans(Class<?> c) {
        Vector<Plan> v = null;
        for (int i = 0; i < this.plan.length; ++i) {
            Plan pc = this.plan[i];
            if (pc.hasError() || !c.isInstance(pc)) continue;
            if (v == null) {
                v = new Vector<Plan>(this.plan.length);
            }
            v.addElement(pc);
        }
        return v;
    }

    protected Vector<Plan> getPlanImg() {
        return this.getPlans(1);
    }

    public Vector<Plan> getPlanBG() {
        return this.getPlans(16);
    }

    protected Vector<Plan> getPlanCat() {
        return this.getPlans(8);
    }

    protected Vector<Plan> getPlanAllImg() {
        return this.getPlans(2048);
    }

    protected Vector<Plan> getPlanSelected() {
        return this.getPlans(4096);
    }

    protected Plan getPlanRef() {
        ViewSimple v = this.aladin.view.getCurrentView();
        return v == null ? null : v.pref;
    }

    protected int getIndexPlanRef() {
        return this.getIndex(this.getPlanRef());
    }

    public Plan getPlanBase() {
        Plan p = this.getPlanRef();
        return p != null && p.isPixel() ? p : null;
    }

    public boolean isModeAllSky() {
        Plan p = this.getPlanRef();
        return p != null && p instanceof PlanBG;
    }

    protected Plan nextImage(Plan pref, int sens) {
        int n = this.getIndex(pref);
        for (int i = n + sens; i != n; i += sens) {
            Plan p;
            if (i >= this.plan.length) {
                i = 0;
            }
            if (i < 0) {
                i = this.plan.length - 1;
            }
            if (!((p = this.plan[i]) instanceof PlanImage) || !p.flagOk) continue;
            return p;
        }
        return pref;
    }

    protected int getIndexPlanBase() {
        int i = this.getIndexPlanRef();
        if (i == -1 || !this.plan[i].isImage() || !this.plan[i].active) {
            return -1;
        }
        return i;
    }

    protected String[] getStackLabels() {
        Vector<String> v = new Vector<String>();
        for (int i = this.plan.length - 1; i >= 0; --i) {
            if (this.plan[i].type == 0) continue;
            v.add(this.plan[i].label);
        }
        String[] s = new String[v.size()];
        Enumeration e = v.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            s[i] = (String)e.nextElement();
            ++i;
        }
        return s;
    }

    protected void updateToolCatPhotExtract(SourceStat r, double[] iqe) {
        final PlanTool p = this.selectPlanTool();
        final SourcePhot s = p.addPhot(this.aladin.view.getMouseView(), r.raj, r.dej, iqe);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Util.pause(100);
                s.setSelected(true);
                p.updateDedicatedFilter();
                Calque.this.repaintAll();
            }
        });
    }

    protected void updateToolCatTag(Tag tag) {
        this.updateToolCatTag(tag, this.aladin.view.getMouseView());
    }

    protected void updateToolCatTag(Tag tag, ViewSimple vs) {
        final PlanTool p = this.selectPlanTool();
        final SourceTag s = p.addTag(vs, tag.raj, tag.dej);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Util.pause(100);
                s.setSelected(true);
                p.updateDedicatedFilter();
                Calque.this.repaintAll();
            }
        });
    }

    protected void resetPlanField(int flag, PlanField[] plan, int n) {
        for (int i = 0; i < n; ++i) {
            plan[i].reset(flag);
        }
    }

    double[] getDefaultTimeRange() {
        ViewSimple v = this.aladin.view.getCurrentView();
        double[] t = v.getTimeRange();
        if ((Double.isNaN(t[0]) || Double.isNaN(t[1])) && (Double.isNaN((t = this.aladin.calque.getGlobalTimeRange())[0]) || Double.isNaN(t[1]))) {
            long d = Util.getTime(2);
            d -= d % 86400L;
            t[0] = Astrodate.UnixToJD(d);
            t[1] = Astrodate.UnixToJD(d + 86399L);
        }
        return t;
    }

    protected Plan newPlanFilter() {
        return this.newPlanFilter(null, null);
    }

    protected Plan newPlanFilter(String label, String script) {
        PlanFilter pc = null;
        int n = this.getStackIndex();
        pc = new PlanFilter(this.aladin, label, script);
        this.plan[n] = pc;
        PlanFilter.updateAllFilters(this.aladin);
        return pc;
    }

    protected Plan createFolder(String label, int folderNiv, boolean localScope) {
        return this.plan[this.newFolder(label, folderNiv, localScope)];
    }

    protected int newFolder(String label, int folderNiv, boolean localScope) {
        int n = this.getStackIndex();
        this.plan[n] = new PlanFolder(this.aladin, label, folderNiv, localScope);
        return n;
    }

    protected int newPlanDMap(String internalId, String catID) throws Exception {
        Glu cfr_ignored_0 = this.aladin.glu;
        String u = "" + this.aladin.glu.getURL(DMAPGLU, Glu.quote(catID));
        String label = internalId + " DMAP";
        int n = this.getStackIndex(label);
        try {
            this.plan[n] = new PlanHealpixDMap(this.aladin, u, label);
        }
        catch (Exception e) {
            this.plan[n].error = e.getMessage();
            throw e;
        }
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanImageRGB(PlanImage r, PlanImage g, PlanImage b, PlanImage ref, String label, boolean diff) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        this.plan[n] = new PlanImageRGB(this.aladin, r, g, b, ref, label, diff);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanImage(PlanImageRGB porig) {
        PlanImage p2 = this.greyPlan(porig);
        ViewSimple v = this.aladin.view.getFirstSelectedView(porig);
        if (v != null) {
            v.pref = p2;
            v.repaint();
        }
        return 1;
    }

    protected int newPlanImageResamp(PlanImage porig, PlanImage p, String label, int methode, boolean fullPixel, boolean keepOrig) {
        PlanImageResamp p2;
        if (porig.type != 5) {
            ViewSimple v;
            if (keepOrig) {
                try {
                    p2 = (PlanImageResamp)this.dupPlan(porig, label, 5, true);
                }
                catch (Exception e) {
                    p2 = null;
                }
                porig.selected = false;
            } else {
                p2 = this.rspPlan(porig);
            }
            if (label == null) {
                p2.setLabel("Rsp " + p2.label);
            }
            if ((v = this.aladin.view.getFirstSelectedView(porig)) != null) {
                v.pref = p2;
                v.repaint();
            }
        } else {
            p2 = (PlanImageResamp)porig;
        }
        p2.launchResampleBy(p, methode, fullPixel);
        return 1;
    }

    protected int newPlanMoc(String label, PlanMoc source, Coord[] coo) {
        if (label == null && source != null) {
            PlanMoc p1 = source;
            label = "=" + p1.getUniqueLabel("[" + p1.getLabel() + "]");
        }
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        PlanMocAlgo pa = new PlanMocAlgo(this.aladin, label, source, coo);
        this.plan[n] = pa;
        if (Calque.isNewPlan(label)) {
            n = this.bestPlace(n);
            pa.folder = 0;
        }
        this.suiteNew(pa);
        return n;
    }

    protected int newPlanMoc(String label, PlanMoc source, double jdmin, double jdmax) {
        if (label == null && source != null) {
            PlanMoc p1 = source;
            label = "=" + p1.getUniqueLabel("[PROJ " + p1.getLabel() + "]");
        }
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        PlanMocAlgo pa = new PlanMocAlgo(this.aladin, label, source, jdmin, jdmax);
        this.plan[n] = pa;
        if (Calque.isNewPlan(label)) {
            n = this.bestPlace(n);
            pa.folder = 0;
        }
        this.suiteNew(pa);
        return n;
    }

    protected int newPlanMoc(String label, PlanMoc[] pList, int op, int spaceOrder, int timeOrder, long maxSize, String maxPriority) {
        PlanMoc pa;
        if (label == null) {
            PlanMoc p1 = pList[0];
            label = "=" + p1.getUniqueLabel("[" + p1.getLabel() + "]");
        }
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        if (spaceOrder >= 0 && timeOrder >= 0 && pList[0] instanceof PlanSTMoc) {
            pa = new PlanSTMocAlgo(this.aladin, label, pList, op, spaceOrder, timeOrder, maxSize, maxPriority);
            this.plan[n] = pa;
        } else if (spaceOrder == -1) {
            pa = new PlanTMocAlgo(this.aladin, label, pList, op, timeOrder, maxSize);
            this.plan[n] = pa;
        } else {
            pa = new PlanMocAlgo(this.aladin, label, pList, op, spaceOrder, maxSize);
            this.plan[n] = pa;
        }
        if (Calque.isNewPlan(label)) {
            n = this.bestPlace(n);
            pa.folder = 0;
        }
        this.suiteNew(pa);
        return n;
    }

    protected int newPlanMocColl(Aladin aladin, String label, String directory, int order, boolean strict, boolean recursive, double blank, int[] hdu) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        PlanMocColl pa = new PlanMocColl(aladin, label, directory, order, strict, recursive, blank, hdu);
        this.plan[n] = pa;
        if (Calque.isNewPlan(label)) {
            n = this.bestPlace(n);
            pa.folder = 0;
        }
        this.suiteNew(pa);
        return n;
    }

    protected int newPlanMoc(String label, Plan[] p, int order, double radius, double pixMin, double pixMax, double threshold, boolean fov) {
        if (label == null) {
            label = "=" + p[0].getUniqueLabel("[" + p[0].getLabel() + "]");
        }
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        PlanMocGen pa = new PlanMocGen(this.aladin, label, p, order, radius, pixMin, pixMax, threshold, fov);
        this.plan[n] = pa;
        if (Calque.isNewPlan(label)) {
            n = this.bestPlace(n);
            pa.folder = 0;
        }
        this.suiteNew(pa);
        return n;
    }

    protected int newPlanTMoc(String label, Plan[] p, int order, double duration) {
        if (label == null) {
            label = "=" + p[0].getUniqueLabel("[" + p[0].getLabel() + "]");
        }
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        PlanTMocGen pa = new PlanTMocGen(this.aladin, label, p, order, duration);
        this.plan[n] = pa;
        if (Calque.isNewPlan(label)) {
            n = this.bestPlace(n);
            pa.folder = 0;
        }
        this.suiteNew(pa);
        return n;
    }

    protected int newPlanSTMoc(String label, Plan[] p, int spaceOrder, int timeOrder, double duration, double radius, boolean fov) {
        if (label == null) {
            label = "=" + p[0].getUniqueLabel("[" + p[0].getLabel() + "]");
        }
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        PlanSTMocGen pa = new PlanSTMocGen(this.aladin, label, p, spaceOrder, timeOrder, duration, radius, fov);
        this.plan[n] = pa;
        if (Calque.isNewPlan(label)) {
            n = this.bestPlace(n);
            pa.folder = 0;
        }
        this.suiteNew(pa);
        return n;
    }

    protected int newPlanSTMoc(String label, Plan[] p, int spaceOrder, int timeOrder, double jdmin, double jdmax) {
        if (label == null) {
            label = "=" + p[0].getUniqueLabel("[" + p[0].getLabel() + "]");
        }
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        PlanSTMocGen pa = new PlanSTMocGen(this.aladin, label, p, spaceOrder, timeOrder, jdmin, jdmax);
        this.plan[n] = pa;
        if (Calque.isNewPlan(label)) {
            n = this.bestPlace(n);
            pa.folder = 0;
        }
        this.suiteNew(pa);
        return n;
    }

    protected int newPlanImageAlgo(String label, PlanImage p1, PlanImage p2, int fct, double coef, String conv, int methode) {
        if (p1 == null) {
            p1 = (PlanImage)this.getPlanBase();
            if (label == null) {
                label = "=" + p1.getLabel();
            }
        } else if (label == null) {
            label = "=" + p1.getUniqueLabel("[" + p1.getLabel() + "]");
        }
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        PlanImageAlgo pa = new PlanImageAlgo(this.aladin, label, p1, p2, fct, coef, conv, methode);
        this.plan[n] = pa;
        if (Calque.isNewPlan(label)) {
            n = this.bestPlace(n);
            pa.folder = 0;
        }
        this.suiteNew(pa);
        return n;
    }

    protected int newPlanHealpixAlgo(String label, PlanHealpix p1, PlanHealpix p2, int fct, double coef) {
        if (p1 == null) {
            p1 = (PlanHealpix)this.getPlanBase();
            if (label == null) {
                label = "=" + p1.getLabel();
            }
        } else if (label == null) {
            label = "=" + p1.getUniqueLabel("[" + p1.getLabel() + "]");
        }
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        System.out.println(p1.getNSideFile());
        System.out.println(p2.getNSideFile());
        if (p2 != null && (p1.getNSideFile() != p2.getNSideFile() || p1.getCoordsys() != p2.getCoordsys())) {
            Aladin.error("Operation on planes with different nside or coordinate system not available yet !", 1);
            return -1;
        }
        PlanHealpixAlgo pa = new PlanHealpixAlgo(this.aladin, label, p1, p2, fct, coef);
        this.plan[n] = pa;
        if (Calque.isNewPlan(label)) {
            n = this.bestPlace(n);
        }
        this.suiteNew(pa);
        return n;
    }

    protected int newPlanImageBlink(PlanImage[] p, String label, int delay) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        this.plan[n] = new PlanImageBlink(this.aladin, p, label, delay);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanImageMosaic(PlanImage[] p, String label, ViewSimple v) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        this.plan[n] = new PlanImageMosaic(this.aladin, p, label, v);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanImage(URL u, int orig, String label, String objet, String param, String from, int fmt, int res, Obj o) {
        return this.newPlanImage(u, null, orig, label, objet, param, from, fmt, res, o);
    }

    protected int newPlanImage(URL u, int orig, String label, String objet, String param, String from, int fmt, int res, Obj o, ResourceNode imgNode) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        this.plan[n] = new PlanImage(this.aladin, null, orig, u, label, objet, param, from, fmt, res, o, imgNode);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanImage(URL u, MyInputStream inImg, int orig, String label, String objet, String param, String from, int fmt, int res, Obj o) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        this.plan[n] = new PlanImage(this.aladin, inImg, orig, u, label, objet, param, from, fmt, res, o);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanImage(URL u, MyInputStream inImg, int orig, String label, String objet, String param, String from, int fmt, int res, Obj o, ResourceNode imgNode) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        long type = 0L;
        try {
            type = inImg.getType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.plan[n] = (type & 0x2000000L) != 0L ? new PlanImageCube(this.aladin, null, inImg, label, from, o, imgNode, false, true, null) : new PlanImage(this.aladin, inImg, orig, u, label, objet, param, from, fmt, res, o, imgNode);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanImageCube(URL u, MyInputStream inImg, int orig, String label, String objet, String param, String from, int fmt, int res, Obj o, ResourceNode imgNode) {
        if (inImg == null) {
            try {
                inImg = Util.openStream(u);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int n = this.getStackIndex();
        this.plan[n] = new PlanImageCube(this.aladin, null, inImg, label, from, o, imgNode, false, true, null);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    private int bestPlace(int n) {
        int i;
        Plan[] plan = this.getPlans();
        Plan p = plan[n];
        int folder = p.folder;
        if (plan[n].type == 16 && !plan[n].isOverlay()) {
            int i2;
            for (i2 = plan.length - 1; i2 >= 0 && plan[i2].type == 16; --i2) {
            }
            if (i2 + 1 == n) {
                return n;
            }
            if (i2 != n) {
                folder = plan[i2].folder;
                this.permute(plan[n], plan[i2]);
            }
            p.folder = folder;
            return i2;
        }
        String t1 = plan[n].getTargetQuery();
        for (i = n + 1; i < plan.length; ++i) {
            Plan pc = plan[i];
            if (pc.type != 12 && pc.type != 13 && (!pc.isOverlay() || !t1.equals(pc.getTargetQuery()) && !(pc instanceof PlanBG))) break;
        }
        if (i > plan.length || i <= 0 || i - 1 == n) {
            return n;
        }
        this.permute(plan[n], plan[i - 1]);
        p.folder = folder;
        return i - 1;
    }

    protected void bestPlacePost(Plan p) {
        int i;
        if (p.noBestPlacePost || p instanceof PlanBG || !Projection.isOk(p.projd)) {
            return;
        }
        boolean overlay = p.isOverlay();
        int folder = p.folder;
        int n = this.getIndex(p);
        for (i = n + 1; i < this.plan.length; ++i) {
            Plan pc = this.plan[i];
            if (pc.type != 12 && pc.type != 13 && pc.flagOk && (overlay || !pc.isOverlay() || !p.projd.agree(pc.projd, null))) break;
        }
        if (i > this.plan.length || i <= 0 || i - 1 == n) {
            return;
        }
        this.permute(p, this.plan[i - 1]);
        p.folder = folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Plan dupPlan(PlanImage p, String label, int type, boolean flagIns) throws Exception {
        if (!p.isImage() && !(p instanceof PlanBG)) {
            throw new Exception("Not yet supported for this kind of plane");
        }
        if (!p.flagOk) {
            throw new Exception("This plane is not yet ready");
        }
        PlanImage pc = null;
        Object object = this.pile;
        synchronized (object) {
            int n = this.getStackIndex(label);
            int m = this.getIndex(p);
            if (flagIns) {
                for (int i = n; i < m - 1; ++i) {
                    this.plan[i] = this.plan[i + 1];
                }
                n = m - 1;
            }
            if (n != m) {
                if (type == -1) {
                    type = p.type;
                }
                switch (type) {
                    case 2: 
                    case 20: {
                        pc = new PlanImageRGB(this.aladin, p);
                        break;
                    }
                    case 7: {
                        pc = new PlanImageAlgo(this.aladin, p);
                        break;
                    }
                    case 5: {
                        pc = new PlanImageResamp(this.aladin, p);
                        break;
                    }
                    case 6: {
                        pc = new PlanImageMosaic(this.aladin, p);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        pc = new PlanImage(this.aladin, p);
                        break;
                    }
                    case 16: {
                        if (((PlanBG)p).color) {
                            pc = new PlanImageRGB(this.aladin, p);
                            break;
                        }
                        pc = new PlanImage(this.aladin, p);
                        break;
                    }
                    case 15: {
                        pc = new PlanImage(this.aladin, p);
                        pc.initZoom /= (double)((PlanImageHuge)p).getStep();
                    }
                }
                this.plan[n] = pc;
                label = this.prepareLabel(label);
                if (label == null) {
                    label = "[" + p.label + "]";
                }
                pc.setLabel(label);
            } else {
                p.isOldPlan = true;
                pc = p;
            }
        }
        this.suiteNew(pc);
        if (flagIns) {
            pc.selected = false;
            pc.active = false;
        } else {
            pc.folder = 0;
            pc.planReady(true);
        }
        return pc;
    }

    protected PlanImageResamp rspPlan(PlanImage p) {
        if (p.type != 1) {
            return null;
        }
        PlanImageResamp pc = null;
        int n = this.getIndex(p);
        pc = new PlanImageResamp(this.aladin, p);
        this.plan[n] = pc;
        this.suiteNew(pc);
        return pc;
    }

    protected PlanImageAlgo algoPlan(PlanImage p) {
        if (!p.isSimpleImage()) {
            return null;
        }
        PlanImageAlgo pc = null;
        int n = this.getIndex(p);
        pc = new PlanImageAlgo(this.aladin, p);
        this.plan[n] = pc;
        this.suiteNew(pc);
        return pc;
    }

    protected PlanImage greyPlan(PlanImageRGB p) {
        if (p.type != 2) {
            return null;
        }
        PlanImage p2 = new PlanImage(this.aladin, p);
        p2.type = 1;
        p2.pixelsOrigin = p.getGreyPixels();
        p2.bitpix = 8;
        p2.npix = 1;
        p2.setBufPixels8(p2.getPix8Bits(null, p2.pixelsOrigin, 8, p.width, p.height, p.dataMinFits, p.dataMaxFits, false, 0, 0, 0));
        p2.calculPixelsZoom();
        p2.fmt = 1;
        p2.video = 0;
        p2.cm = CanvasColorMap.getCM(0, 128, 255, p2.video == 1, this.aladin.configuration.getCMMap(), this.aladin.configuration.getCMFct());
        p2.cmControl[0] = 0;
        p2.cmControl[1] = 128;
        p2.cmControl[2] = 255;
        p2.setPixMode(3);
        p2.changeImgID();
        p2.setPourcent(-1.0);
        int n = this.getIndex(p);
        this.plan[n] = p2;
        this.suiteNew(p2);
        p.Free();
        return p2;
    }

    protected int newPlanImage(MyInputStream inImg, String label) {
        PlanImage pc = null;
        int n = -1;
        n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        pc = new PlanImage(this.aladin, inImg, label);
        this.plan[n] = pc;
        this.suiteNew(pc);
        return n;
    }

    protected int newPlanImage(InputStream inImg, String label, String from) {
        PlanImage pc = null;
        int n = -1;
        n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        pc = new PlanImage(this.aladin, inImg, label, from);
        this.plan[n] = pc;
        this.suiteNew(pc);
        return n;
    }

    protected int[] getNumExt(String file) {
        String s = file;
        int[] x = new int[1000];
        int nx = 0;
        try {
            int i = s.lastIndexOf(91);
            if (i < 0) {
                return null;
            }
            int j = s.indexOf(93, i);
            if (j < 0 || j != s.length() - 1) {
                return null;
            }
            s = s.substring(i + 1, j);
            StringTokenizer st = new StringTokenizer(s, ",;");
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                i = t.indexOf(45);
                if (i > 0) {
                    int a1 = Integer.parseInt(t.substring(0, i));
                    int a2 = Integer.parseInt(t.substring(i + 1));
                    i = a1;
                    while (i <= a2) {
                        x[nx++] = i++;
                    }
                } else {
                    x[nx++] = Integer.parseInt(t);
                }
                if (nx != 1000) continue;
                Aladin.error(this, "Too many Fits extension/frame designation ");
                return null;
            }
        }
        catch (Exception e) {
            Aladin.error(this, "Bad FITS extension/frame designation " + s);
            return null;
        }
        int[] y = new int[nx];
        System.arraycopy(x, 0, y, 0, nx);
        return y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newFitsExt(String file, MyInputStream in, String label, Obj o, String target, String radius) {
        if (file != null && label == null) {
            int i = file.lastIndexOf(Util.FS);
            label = i >= 0 ? file.substring(i + 1) : file;
        } else if (label == null) {
            label = "Fits ext";
        }
        this.waitLock();
        this._target = target;
        this._radius = radius;
        this._file = file;
        this._in = in;
        this._firstPlan = new PlanImage(this.aladin);
        this._firstPlan.dis = in;
        this._firstPlan.setLabel(label);
        this._firstPlan.flagOk = false;
        Object i = this.pile;
        synchronized (i) {
            int n = this.getStackIndex();
            this.plan[n] = this._firstPlan;
        }
        int n = label.lastIndexOf(46);
        this._label = n > 0 ? label.substring(0, n) : label;
        this._o = o;
        this.select.repaint();
        Thread runme = new Thread((Runnable)this, "AladinFitsExtQuery");
        Util.decreasePriority(Thread.currentThread(), runme);
        Plan.aladinQueryThread(runme);
        runme.start();
    }

    private void waitLock() {
        while (!this.getLock()) {
            Util.pause(10);
        }
    }

    private void unlock() {
        this.lock = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getLock() {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.lock) {
                return false;
            }
            this.lock = true;
            return true;
        }
    }

    @Override
    public void run() {
        this.newFitsExtThread();
        this.stack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stack() {
        Object object = this.pile;
        synchronized (object) {
            int j = this.plan.length - 1;
            for (int i = this.plan.length - 1; i >= 0; --i) {
                if (this.plan[i].isEmpty() || this.plan[i].type == 0) continue;
                this.plan[j--] = this.plan[i];
            }
            while (j >= 0) {
                if (!this.plan[j].isEmpty() && this.plan[j].type != 0) {
                    this.plan[j] = new PlanFree(this.aladin);
                }
                --j;
            }
        }
    }

    private boolean keepFitsExt(int n, int[] numext) {
        if (numext == null) {
            return true;
        }
        for (int i = 0; i < numext.length; ++i) {
            if (numext[i] != n) continue;
            numext[i] = -1;
            return true;
        }
        return false;
    }

    private boolean allFitsExt(int[] numext) {
        if (numext == null) {
            return false;
        }
        for (int i = 0; i < numext.length; ++i) {
            if (numext[i] == -1) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newFitsExtThread() {
        Plan p = null;
        String target = this._target;
        String radius = this._radius;
        String file = this._file;
        MyInputStream in = this._in;
        String label = this._label;
        PlanFolder folder = new PlanFolder(this.aladin, label);
        Plan firstPlan = this._firstPlan;
        Obj o = this._o;
        int step = 0;
        int[] numext = null;
        if (file != null) {
            numext = this.getNumExt(file);
        }
        this.unlock();
        Vector<Plan> v = new Vector<Plan>();
        try {
            int nbExt = 0;
            int nExt = 0;
            while (!this.allFitsExt(numext)) {
                long pos;
                boolean keepIt = this.keepFitsExt(nExt, numext);
                p = null;
                in.resetType();
                long type = in.getType();
                if ((type & 0x80000000000L) != 0L) {
                    break;
                }
                Aladin.trace(3, "MultiExtension " + nExt + " detect => " + MyInputStream.decodeType(type));
                if ((type & 1L) != 0L) {
                    PlanImage pi = null;
                    pi = (type & 0x2000000L) != 0L ? ((type & 0x400000000L) != 0L ? new PlanImageCubeRGB(this.aladin, file, in, label, null, o, null, false, false, null) : new PlanImageCube(this.aladin, file, in, label + "[" + nExt + "]", null, o, null, !keepIt, false, firstPlan)) : ((type & 0x8000000L) != 0L ? new PlanImageHuge(this.aladin, file, in, label + "[" + nExt + "]", null, o, null, !keepIt, false, firstPlan) : ((type & 0x100000000L) != 0L ? new PlanHealpix(this.aladin, file, in, label + "[" + nExt + "]", 0, 0, false, this.getTargetBG(target, null), this.getRadiusBG(target, radius, null)) : new PlanImage(this.aladin, file, in, label + "[" + nExt + "]", null, o, null, !keepIt, false, firstPlan)));
                    if (nExt == 0 && pi.error != null && pi.error.equals("_HEAD_XFITS_")) {
                        folder.headerFits = pi.headerFits;
                    } else {
                        if (pi.error == null || pi.error.equals("_END_XFITS_")) {
                            pi.pixelsOriginIntoCache();
                        }
                        p = pi;
                    }
                } else {
                    if ((type & 0x1800000L) == 0L) {
                        Aladin.trace(3, "One MEF extension not supported => ignored!");
                        break;
                    }
                    if ((type & 0x80000000L) != 0L) {
                        p = new PlanImageFitsCmp(this.aladin, file, in, label, null, o, null, !keepIt, false, firstPlan);
                    } else if (this.aladin.configuration.isFilterHDU() && (type & 0x10000000L) != 0L) {
                        Aladin.trace(3, "MEF AIPS CC table detected => ignored !");
                        new PlanCatalog(this.aladin, "", in, true, false);
                    } else {
                        PlanCatalog pc = new PlanCatalog(this.aladin, "", in, !keepIt, false, false);
                        if (pc.label.equals("")) {
                            pc.setLabel(file);
                        }
                        p = pc;
                        if (this.aladin.configuration.isFilterHDU() && (pc.pcat.badRaDecDetection || pc.pcat.getCount() == 0) && nExt > 0 && v.size() > 0 && v.elementAt(0).isImage()) {
                            p = null;
                            this.aladin.command.printConsole("!!! Table MEF extension ignored => seems to be reduction information");
                        }
                    }
                }
                if (p != null) {
                    folder.setPourcent(++nbExt);
                    if (p.error != null && p.error.equals("_END_XFITS_")) {
                        break;
                    }
                    if (keepIt) {
                        if (p.isImage()) {
                            ((PlanImage)p).pixelsOriginIntoCache();
                        }
                        p.askActive = !p.isImage();
                        p.selected = false;
                        v.add(p);
                        if (p.label == null || p.label.equals("") || p.label.startsWith("~")) {
                            p.setLabel(label + (v.size() > 0 ? "[" + nExt + "]" : ""));
                        }
                        if (step < 2) {
                            Object pc = this.pile;
                            synchronized (pc) {
                                int n = this.getIndex(firstPlan);
                                if (step == 0) {
                                    firstPlan = this.plan[n] = p;
                                } else if (step == 1) {
                                    this.plan[n] = folder;
                                }
                                ++step;
                            }
                            this.select.repaint();
                        }
                    }
                }
                if ((pos = in.getPos()) % 2880L != 0L) {
                    long offset = (pos / 2880L + 1L) * 2880L - pos;
                    in.skip(offset);
                }
                ++nExt;
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (PlanMultiCCD.isMultiCCD(v)) {
            if (label.charAt(0) == '=') {
                label = label.substring(1);
            }
            p = new PlanMultiCCD(this.aladin, label, v);
            Object object = this.pile;
            synchronized (object) {
                int n = this.getIndex(folder);
                this.plan[n] = p;
            }
            p.planReady(true);
            this.select.repaint();
            return;
        }
        folder.planReady(true);
        if (v.size() == 0) {
            return;
        }
        if (v.size() > 1) {
            Object object = this.pile;
            synchronized (object) {
                Enumeration<Plan> e = v.elements();
                while (e.hasMoreElements()) {
                    p = e.nextElement();
                    if (p.isEmpty() || p.type == 0 || p.error != null && p.error.equals("_HEAD_XFITS_")) continue;
                    int n = this.getStackIndex();
                    this.plan[n] = p;
                    this.plan[n].setLabel(this.plan[n].label);
                    this.permute(this.plan[n], folder);
                }
            }
        }
        p = v.elementAt(0);
        if (v.size() == 1) {
            if (label.charAt(0) == '=') {
                label = label.substring(1);
            }
            p.setLabel(label);
        }
        p.doClose = true;
        p.planReady(true);
    }

    public void seekFitsExt(MyInputStream in, int numExt) throws Exception {
        for (int nExt = 0; nExt < numExt; ++nExt) {
            Plan p = null;
            in.resetType();
            long type = in.getType();
            if ((type & 1L) != 0L) {
                p = new PlanImage(this.aladin, "", in, "", null, null, null, true, false, null);
            } else if ((type & 0x1800000L) != 0L) {
                p = new PlanCatalog(this.aladin, "", in, true, false);
            } else {
                Aladin.trace(3, "Extension type not supported !");
                break;
            }
            if (p != null && p.error != null && p.error.equals("_END_XFITS_")) {
                throw new EOFException();
            }
            long pos = in.getPos();
            if (pos % 2880L == 0L) continue;
            long offset = (pos / 2880L + 1L) * 2880L - pos;
            in.skip(offset);
        }
    }

    protected int newPlanImage(String file, MyInputStream inImg, String label, String from, Obj o, ResourceNode imgNode) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        long type = 0L;
        try {
            type = inImg.getType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.plan[n] = (type & 0x2000000L) != 0L && (type & 0x400000000L) != 0L ? new PlanImageCubeRGB(this.aladin, file, inImg, label, from, o, imgNode, false, true, null) : ((type & 0x2000000L) != 0L ? new PlanImageCube(this.aladin, file, inImg, label, from, o, imgNode, false, true, null) : ((type & 0x8000000L) != 0L ? new PlanImageHuge(this.aladin, file, inImg, label, from, o, imgNode, false, true, null) : new PlanImage(this.aladin, file, inImg, label, from, o, imgNode, false, true, null)));
        if (Calque.isNewPlan(label)) {
            n = this.bestPlace(n);
        }
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected static boolean isNewPlan(String label) {
        return label == null || label.length() <= 0 || label.charAt(0) != '=';
    }

    protected String newPlanPlugImg(String name) {
        int n = this.getStackIndex();
        PlanImage p = new PlanImage(this.aladin);
        this.plan[n] = p;
        p.setLabel(name);
        p.creatDefaultCM();
        p.orig = 3;
        p.flagOk = true;
        return p.getLabel();
    }

    protected String newPlanPlugCat(String name) {
        int n = this.getStackIndex();
        PlanCatalog p = new PlanCatalog(this.aladin);
        this.plan[n] = p;
        p.setLabel(name);
        return p.getLabel();
    }

    protected String newPlanPlugTool(String name) {
        PlanTool p = this.createPlanTool(name);
        return p.getLabel();
    }

    protected int newPlanImageRGB(String file, URL u, MyInputStream inImg) {
        int n = this.getStackIndex();
        if (n < 0) {
            return -1;
        }
        this.plan[n] = new PlanImageRGB(this.aladin, file, u, inImg);
        this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanImageRGB(URL u, MyInputStream inImg, int orig, String label, String objet, String param, String from, int fmt, int res, Obj o, ResourceNode imgNode) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        this.plan[n] = new PlanImageRGB(this.aladin, inImg, orig, u, label, objet, param, from, fmt, res, o, imgNode);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanImageRGB(String file, URL u, MyInputStream inImg, ResourceNode imgNode) {
        int n = this.getStackIndex();
        this.plan[n] = new PlanImageRGB(this.aladin, file, u, inImg, imgNode);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanHealpix(String file, MyInputStream inImg, String label, int mode, int idxFieldToRead, boolean fromProperties) {
        return this.newPlanHealpix(file, inImg, label, mode, idxFieldToRead, fromProperties, null, null);
    }

    protected int newPlanHealpix(String file, MyInputStream inImg, String label, int mode, int idxFieldToRead, boolean fromProperties, String target, String radius) {
        Coord c = this.getTargetBG(target, null);
        double rad = this.getRadiusBG(target, radius, null);
        int n = this.getStackIndex();
        this.plan[n] = new PlanHealpix(this.aladin, file, inImg, label, mode, idxFieldToRead, fromProperties, c, rad);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanImageColor(String file, URL u, MyInputStream inImg) {
        int n = this.getStackIndex();
        this.plan[n] = new PlanImageColor(this.aladin, file, u, inImg);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanImageColor(URL u, MyInputStream inImg, int orig, String label, String objet, String param, String from, int fmt, int res, Obj o, ResourceNode imgNode) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        this.plan[n] = new PlanImageColor(this.aladin, inImg, orig, u, label, objet, param, from, fmt, res, o, imgNode);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanImageColor(String file, URL u, MyInputStream inImg, ResourceNode imgNode) {
        int n = this.getStackIndex();
        this.plan[n] = new PlanImageColor(this.aladin, file, u, inImg, imgNode);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected boolean planToolOk(Plan p, boolean flagWithFoV) {
        return (p.type == 9 || flagWithFoV && p.type == 10) && p.isReady() && p.isSelectable() && !(p instanceof PlanMoc);
    }

    protected PlanTool selectPlanTool() {
        return (PlanTool)this.selectPlanTool1(false);
    }

    protected Plan selectPlanToolOrFoV() {
        return this.selectPlanTool1(true);
    }

    private Plan selectPlanTool1(boolean flagWithFoV) {
        try {
            Plan p = this.getFirstSelectedPlan();
            ViewSimple v = this.aladin.view.getCurrentView();
            int indexView = this.getIndex(v.pref);
            if (this.planToolOk(p, flagWithFoV) && this.getIndex(p) < indexView) {
                return p;
            }
            Plan[] plan = this.getPlans();
            for (int i = 0; i < plan.length && i < indexView; ++i) {
                if (!this.planToolOk(plan[i], flagWithFoV)) continue;
                this.selectPlan(plan[i]);
                return plan[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createPlanTool(null);
    }

    protected PlanTool newPlanTool(String label) {
        return this.createPlanTool(label);
    }

    protected PlanTool createPlanTool(String label) {
        int n = this.getStackIndex();
        PlanTool p = new PlanTool(this.aladin, label);
        this.plan[n] = p;
        p.selected = true;
        p.active = true;
        Plan pref = this.getPlanRef();
        Projection projection = p.projd = pref == null || !Projection.isOk(pref.projd) ? null : new Projection("Myproj", 2, pref.projd.alphai, pref.projd.deltai, 5400.0, 250.0, 250.0, 500.0, 0.0, false, 4, Calib.FK5, pref);
        if (pref != null) {
            p.setBody(pref.getBody());
        }
        this.suiteNew(p);
        this.aladin.command.resetPreviousDrawing();
        return p;
    }

    protected PlanField createPlanField(String label, Coord center, double angle, boolean canbeRoll, boolean canbeMove) {
        int n = this.getStackIndex();
        PlanField p = new PlanField(this.aladin, label, center, angle, canbeRoll, canbeMove);
        this.plan[n] = p;
        p.active = true;
        this.suiteNew(p);
        return p;
    }

    protected int newPlanFov(String label, Fov[] fov) {
        int n = this.getStackIndex();
        this.plan[n] = new PlanFov(this.aladin, label, fov);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanContour(String label, PlanImage pimg, double[] levels, ContourAlgorithm cAlgo, boolean useSmoothing, int smoothingLevel, boolean useOnlyCurrentZoom, boolean reduceNoise, Color[] couleurs) {
        int n = this.getStackIndex();
        if (levels == null) {
            this.plan[n] = new PlanContour(this.aladin, label);
        } else {
            Color coul = PlanContour.getNextColor(this.aladin.calque);
            this.plan[n] = new PlanContour(this.aladin, label, pimg, levels, cAlgo, useSmoothing, smoothingLevel, useOnlyCurrentZoom, reduceNoise, couleurs, coul);
        }
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanField(String target, double roll, String instr, String label) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        this.plan[n] = new PlanField(this.aladin, target, roll, instr, instr);
        if (((PlanField)this.plan[n]).needTarget && this.plan[n].objet != null) {
            this.aladin.view.setRepere(this.plan[n]);
        }
        this.suiteNew(this.plan[n]);
        this.plan[n].planReady(!((PlanField)this.plan[n]).needTarget);
        return n;
    }

    protected int newPlanField(FootprintBean fpBean, String target, String label, double roll) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        this.plan[n] = new PlanField(this.aladin, target, fpBean, label, roll);
        if (((PlanField)this.plan[n]).needTarget && this.plan[n].objet != null) {
            this.aladin.view.setRepere(this.plan[n]);
        }
        this.suiteNew(this.plan[n]);
        this.plan[n].planReady(!((PlanField)this.plan[n]).needTarget);
        return n;
    }

    protected int newPlanField(PlanField pf, String label) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        this.plan[n] = pf;
        pf.setLabel(label);
        this.suiteNew(this.plan[n]);
        this.plan[n].planReady(!((PlanField)this.plan[n]).needTarget);
        return n;
    }

    protected void setCenterForField(double al, double del) {
        for (int i = 0; i < this.plan.length; ++i) {
            if (this.plan[i].type != 10 || !((PlanField)this.plan[i]).needTarget) continue;
            ((PlanField)this.plan[i]).resolveTarget(al, del);
        }
    }

    protected void newPlanImageFromBlink(PlanImageBlink cube, int frame) throws Exception {
        if (frame == -1) {
            frame = this.aladin.view.getView((Plan)cube).cubeControl.lastFrame;
        }
        cube.activePixelsOrigin(frame);
        PlanImage pi = (PlanImage)this.aladin.calque.dupPlan(cube, null, cube.type, false);
        pi.setLabel(cube.label + "#" + frame);
        pi.setHasSpecificCalib();
        pi.headerFits.setKeyValue("NAXIS", "2");
        pi.isOldPlan = false;
        pi.selected = false;
        pi.pourcent = -1.0;
        pi.flagOk = true;
        pi.type = 1;
        pi.copyright = "Extract from " + cube.label + " (frame #" + (frame + 1) + ")";
    }

    protected void newPlanImageByCrop(final ViewSimple v, final RectangleD rcrop, final double resMult, final boolean fullRes) {
        final double zoom = v.zoom;
        new Thread("crop"){

            @Override
            public void run() {
                v.cropArea(rcrop, null, zoom, resMult, fullRes, true);
                Calque.this.repaintAll();
            }
        }.start();
    }

    protected String newPlanCatalogByCatalogs(Plan[] pList, boolean uniqTable, String label) {
        StringBuilder list = null;
        Plan[] p = pList != null ? pList : this.getPlans();
        Vector<Source> v = new Vector<Source>(100000);
        for (int i = 0; i < p.length; ++i) {
            if (!p[i].isCatalog() || !p[i].flagOk || pList == null && !p[i].selected) continue;
            if (list == null) {
                list = new StringBuilder(Tok.quote(p[i].label));
            } else {
                list.append(" " + Tok.quote(p[i].label));
            }
            Iterator<Obj> it = p[i].iterator();
            while (it.hasNext()) {
                Obj o = it.next();
                if (!o.asSource()) continue;
                Source s = (Source)o;
                v.addElement(s);
            }
        }
        this.newPlanCatalogBySources(v, label, uniqTable);
        this.repaintAll();
        return list == null ? "" : list.toString();
    }

    protected void newPlanCatalogBySelectedObjet(boolean uniqTable) {
        this.newPlanCatalogBySelectedObjet("Select.src", uniqTable);
    }

    protected void newPlanCatalogBySelectedObjet(String label, boolean uniqTable) {
        Vector<Obj> v = this.aladin.view.getSelectedObjet();
        PlanCatalog p = this.newPlanCatalogBySources(v, label, uniqTable);
        if (p != null) {
            this.aladin.view.selectAllInPlan(p);
        }
    }

    protected PlanCatalog newPlanCatalogBySources(Vector vSources, String label, boolean uniqTable) {
        return this.newPlanCatalogBySources(vSources, label, uniqTable, true);
    }

    protected PlanCatalog newPlanCatalogBySources(Vector vSources, String label, boolean uniqTable, boolean inStack) {
        PlanCatalog p;
        if (vSources == null) {
            return null;
        }
        if (label == null || label.length() == 0) {
            label = "New.cat";
        }
        if (inStack) {
            int n = this.getStackIndex(label);
            label = this.prepareLabel(label);
            this.newPlanCatalog(n);
            p = (PlanCatalog)this.plan[n];
        } else {
            p = new PlanCatalog(this.aladin);
        }
        p.setLabel(label);
        if (!uniqTable) {
            Vector<Legende> legs = new Vector<Legende>(10);
            Enumeration e = vSources.elements();
            while (e.hasMoreElements()) {
                Obj o = (Obj)e.nextElement();
                if (!o.asSource()) continue;
                Source s = (Source)o;
                Source newSource = new Source((Plan)p, s.raj, s.dej, s.jdtime, s.id, s.info);
                p.pcat.setObjetFast(newSource);
                newSource.isSelected = s.isSelected;
                newSource.values = s.values;
                newSource.actions = s.actions;
                newSource.setLeg(s.getLeg());
                SourceFootprint sourceFootprint = newSource.sourceFootprint = s.sourceFootprint == null ? null : s.sourceFootprint.copy();
                if (legs.contains(s.getLeg())) continue;
                legs.addElement(s.getLeg());
            }
            p.pcat.nbTable = legs.size();
        } else {
            Source s;
            ArrayList<Legende> leg = new ArrayList<Legende>(10);
            Enumeration e = vSources.elements();
            while (e.hasMoreElements()) {
                Obj o = (Obj)e.nextElement();
                if (!o.asSource() || leg.contains((s = (Source)o).getLeg())) continue;
                leg.add(s.getLeg());
            }
            Legende legGen = new Legende(leg);
            e = vSources.elements();
            while (e.hasMoreElements()) {
                Obj o = (Obj)e.nextElement();
                if (!o.asSource()) continue;
                s = (Source)o;
                String info = this.createInfo(s, legGen);
                Source newSource = new Source((Plan)p, s.raj, s.dej, s.jdtime, s.id, info);
                p.pcat.setObjetFast(newSource);
                p.pcat.nbTable = 1;
                newSource.setLeg(legGen);
            }
        }
        if (inStack) {
            p.pcat.createDefaultProj();
            p.setActivated(true);
            if (this.aladin.calque.getPlanRef() != null) {
                p.objet = this.aladin.calque.getPlanRef().objet;
                p.body = this.aladin.calque.getPlanRef().body;
            }
            TapManager.getInstance(this.aladin).updateAddUploadPlans(p);
        } else {
            p.flagOk = true;
            p.active = true;
        }
        return p;
    }

    private String createInfo(Source s, Legende leg) {
        String[] v = new String[leg.getSize()];
        int offset = s.info.indexOf(9);
        int start = offset + 1;
        int i = 0;
        while (offset != -1) {
            offset = s.info.indexOf(9, start);
            int j = leg.find(s.getLeg().field[i]);
            if (j != -1) {
                v[j] = offset != -1 ? s.info.substring(start, offset) : s.info.substring(start);
                start = offset + 1;
            }
            ++i;
        }
        StringBuffer info = new StringBuffer("<&_X|X>");
        for (int i2 = 0; i2 < v.length; ++i2) {
            info.append("\t" + (v[i2] == null ? " " : v[i2]));
        }
        return info.toString();
    }

    protected int newPlanCatalog(URL u, String label, String objet, String param, String from, Server server) {
        return this.newPlanCatalog(u, null, label, objet, param, from, server);
    }

    protected int newPlanCatalog(URL u, MyInputStream in, String label, String objet, String param, String from, Server server) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        this.plan[n] = new PlanCatalog(this.aladin, u, in, label, objet, param, from, server);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanCatalog(String file) {
        return this.newPlanCatalog(file, null);
    }

    protected int newPlanCatalog(String file, MyInputStream in) {
        int n = this.getStackIndex();
        this.plan[n] = new PlanCatalog(this.aladin, file, in, false, true);
        this.suiteNew(this.plan[n]);
        return n;
    }

    Plan moc2STMoc(PlanMoc p, int timeOrder, double jdmin, double jdmax) {
        int n = this.getIndex(p);
        PlanSTMocGen p1 = new PlanSTMocGen(this.aladin, null, new Plan[]{p}, -1, timeOrder, jdmin, jdmax);
        p1.label = p.label;
        p1.c = p.c;
        this.plan[n] = p1;
        this.aladin.console.printCommand(Tok.quote(p.label) + " = cmoc -spacetime -order=/" + timeOrder + " -timeRange=" + Astrodate.JDToDate(jdmin) + "/" + Astrodate.JDToDate(jdmax) + " " + Tok.quote(p.label));
        return p1;
    }

    PlanImage createCropImage(ViewSimple v, boolean fullRes) throws Exception {
        if (!(v.pref instanceof PlanBG)) {
            throw new Exception("Cropping only on HiPS");
        }
        PointD p1 = v.getPosition(0.0, 0.0);
        return v.cropAreaBG(new RectangleD(p1.x, p1.y, (double)v.rv.width / v.zoom, (double)v.rv.height / v.zoom), "Crop." + v.pref.label, v.zoom, 1.0, fullRes, false);
    }

    PlanImage createCropImage(ViewSimple v, STCObj stcObj, boolean fullRes) throws Exception {
        if (!(v.pref instanceof PlanBG)) {
            throw new Exception("Cropping only on HiPS");
        }
        PointD p1 = v.getPosition(0.0, 0.0);
        return v.cropAreaBG(new RectangleD(p1.x, p1.y, (double)v.rv.width / v.zoom, (double)v.rv.height / v.zoom), stcObj, "Crop." + v.pref.label, v.zoom, 1.0, fullRes, false);
    }

    protected Plan createPlanCatalog(MyInputStream in, String label) {
        int n = this.newPlanCatalog(in, label);
        return this.plan[n];
    }

    protected int newPlan(Plan p) {
        int n = this.getStackIndex();
        this.plan[n] = p;
        this.suiteNew(p);
        return n;
    }

    protected int newPlanCatalog(MyInputStream in, String label) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        this.plan[n] = new PlanCatalog(this.aladin, in, label);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanCatalog(HttpURLConnection in, String label) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        this.plan[n] = new PlanCatalog(this.aladin, in, label);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanDebug(HttpURLConnection in) {
        try {
            MyInputStream mis = new MyInputStream(in.getInputStream());
            byte[] buf = mis.readFully();
            System.out.println("---DEBUG---\n");
            System.out.println(new String(buf));
            mis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    protected int newPlanCatalog(MyInputStream in, String label, String origin, Server server, URL url, String query, int requestNumber) {
        int n = this.getStackIndex(label);
        Color color = Calque.isNewPlan(label) ? null : this.plan[n].c;
        label = this.prepareLabel(label);
        this.plan[n] = new PlanCatalog(this.aladin, in, label, origin, server, url, query, requestNumber, color);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected String prepareLabel(String label) {
        if (!Calque.isNewPlan(label)) {
            if (label.charAt(1) == '@') {
                int n;
                try {
                    n = Integer.parseInt(label.substring(2));
                    n = this.plan.length - n;
                }
                catch (Exception e) {
                    return null;
                }
                if (this.plan[n].type == 0 || this.plan[n].type == 14) {
                    return null;
                }
                return "=" + this.plan[n].label;
            }
            String s = label.substring(1);
            if (this.getIndexPlan(s, 1) < 0) {
                return s;
            }
        }
        return label;
    }

    private Vector<Plan> splitCatalog1(PlanCatalog p) {
        Vector<Plan> v = new Vector<Plan>(10);
        PlanCatalog p1 = null;
        Legende leg = null;
        int folder = p.folder;
        PlanFolder fold = new PlanFolder(this.aladin, p.label, folder, false);
        fold.label = p.label;
        fold.active = true;
        fold.projd = p.projd;
        fold.u = p.u;
        fold.pcat = new Pcat(fold, null, this, null, this.aladin);
        fold.pcat.description = p.pcat.description;
        fold.pcat.parsingInfo = p.pcat.parsingInfo;
        v.addElement(fold);
        Iterator<Obj> it = p.iterator();
        while (it.hasNext()) {
            Obj o1 = it.next();
            if (!o1.asSource()) continue;
            Source o = (Source)o1;
            if (o.getLeg() != leg) {
                p1 = new PlanCatalog(this.aladin);
                p1.server = p.server;
                p1.c = p.c;
                p1.folder = folder + 1;
                p1.copyright = p.copyright;
                p1.co = p.co;
                p1.param = p.param;
                p1.objet = p.objet;
                p1.body = p.body;
                p1.pcat.nbTable = 1;
                p1.sourceType = p.sourceType;
                p1.fullSource = p.fullSource;
                p1.planFilter = p.planFilter;
                p1.pcat.parsingInfo = p.pcat.parsingInfo;
                p1.projd = p.projd.copy();
                p1.setLabel(p1.getTableName(o));
                v.addElement(p1);
                leg = o.getLeg();
            }
            o.plan = p1;
            p1.pcat.setObjetFast(o);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void splitCatalog(PlanCatalog p) {
        if (p.getNbTable() == 1) {
            return;
        }
        Vector<Plan> v = this.splitCatalog1(p);
        int m = v.size() - 1;
        this.getStackIndex(null, m);
        Object object = this.pile;
        synchronized (object) {
            int i;
            int n = this.getIndex(p);
            for (i = 0; i < n - m; ++i) {
                this.plan[i] = this.plan[i + m];
            }
            for (i = 0; i <= m; ++i) {
                Plan p1;
                this.plan[n - m + i] = p1 = v.elementAt(i);
                p1.setActivated(true);
                if (i <= 1) continue;
                p1.c = Couleur.getNextDefault(this);
            }
        }
        this.stack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void splitMoc(Plan pm) {
        try {
            PlanMoc p = (PlanMoc)pm;
            Vector v = this.splitMoc1(p);
            int m = v.size() - 1;
            if (m <= 0) {
                throw new Exception();
            }
            this.getStackIndex(null, m);
            Object object = this.pile;
            synchronized (object) {
                int i;
                int n = this.getIndex(p);
                for (i = 0; i < n - m; ++i) {
                    this.plan[i] = this.plan[i + m];
                }
                for (i = 0; i <= m; ++i) {
                    Plan p1;
                    this.plan[n - m + i] = p1 = (Plan)v.elementAt(i);
                    p1.setActivated(true);
                    if (i <= 1) continue;
                    p1.c = Couleur.getNextDefault(this);
                }
            }
            this.stack();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.error("Moc split error on " + pm.label);
        }
    }

    private Vector splitMoc1(PlanMoc p) throws Exception {
        Vector<Plan> v = new Vector<Plan>();
        int folder = p.folder;
        SMoc[] smoc = p.getMoc().getSpaceMoc().split(new Healpix(), true);
        boolean collapse = false;
        if (smoc.length > 10) {
            if (!Aladin.confirmation("Do you really want to create " + smoc.length + " sub-MOCs")) {
                return v;
            }
            collapse = true;
        }
        PlanFolder fold = new PlanFolder(this.aladin, p.label, folder, false);
        fold.label = "Split " + p.label;
        fold.active = true;
        fold.headerFits = p.headerFits;
        fold.u = p.u;
        fold.body = p.body;
        v.addElement(fold);
        int i = 0;
        for (SMoc moc : smoc) {
            PlanMoc p1 = new PlanMoc(this.aladin, moc, "subMoc " + ++i);
            p1.folder = folder + 1;
            p1.body = p.body;
            p1.collapse = collapse;
            v.add(p1);
        }
        return v;
    }

    protected int newPlanCatalog() {
        return this.newPlanCatalog(-1);
    }

    protected int newPlanCatalog(int n) {
        if (n == -1) {
            n = this.getStackIndex();
        }
        this.plan[n] = new PlanCatalog(this.aladin);
        Projection proj = this.aladin.view.getCurrentView().getProj();
        this.plan[n].projd = proj == null ? null : proj.copy();
        this.suiteNew(this.plan[n]);
        return n;
    }

    boolean isBackGround() {
        Plan p = this.getPlanBase();
        return p != null && p.type == 16;
    }

    protected Coord getTargetBG(String target, TreeObjDir gSky) {
        Coord c;
        block8: {
            c = null;
            if (target != null && target.length() > 0) {
                try {
                    if (!Localisation.notCoord(target)) {
                        c = new Coord(target);
                        break block8;
                    }
                    c = this.aladin.view.sesame(target);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (gSky != null && gSky.getTarget() != null) {
                c = gSky.getTarget();
            } else if (!this.aladin.view.isFree() && this.aladin.view.repere != null && !Double.isNaN(this.aladin.view.repere.raj)) {
                c = new Coord(this.aladin.view.repere.raj, this.aladin.view.repere.dej);
            }
        }
        return c;
    }

    protected double getRadiusBG(String target, String radius, TreeObjDir gSky) {
        double rad = -1.0;
        if (radius != null && radius.length() > 0) {
            try {
                rad = Server.getAngleInArcmin(radius, 1) / 60.0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (gSky != null && gSky.getRadius() != -1.0) {
            rad = gSky.getRadius();
        } else if ((target == null || target.length() == 0) && rad == -1.0) {
            try {
                rad = this.aladin.view.getCurrentView().getTaille();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rad;
    }

    protected int newPlanMOC(MyInputStream in, String label, String url) {
        long t = 0L;
        try {
            t = in.getType();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ((t & 0x8000000000000L) != 0L) {
            return this.newPlanSTMOC(in, label, url);
        }
        if ((t & 0x4000000000000L) != 0L) {
            return this.newPlanTMOC(in, label, url);
        }
        return this.newPlanSMOC(in, label, url);
    }

    protected int newPlanSMOC(MyInputStream in, String label, String url) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        Coord c = this.getTargetBG(null, null);
        double rad = this.getRadiusBG(null, null, null);
        this.plan[n] = new PlanMoc(this.aladin, in, label, c, rad, url);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanTMOC(MyInputStream in, String label, String url) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        this.plan[n] = new PlanTMoc(this.aladin, in, label, url);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanSTMOC(MyInputStream in, String label, String url) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        Coord c = this.getTargetBG(null, null);
        double rad = this.getRadiusBG(null, null, null);
        this.plan[n] = new PlanSTMoc(this.aladin, in, label, c, rad, url);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanMOC(Moc moc, String label, String url) {
        if (moc instanceof STMoc) {
            return this.newPlanSTMOC((STMoc)moc, label, url);
        }
        if (moc instanceof TMoc) {
            return this.newPlanTMOC((TMoc)moc, label, url);
        }
        return this.newPlanSMOC(moc, label, url);
    }

    protected int newPlanSMOC(Moc moc, String label, String url) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        Coord c = this.getTargetBG(null, null);
        double rad = this.getRadiusBG(null, null, null);
        this.plan[n] = new PlanMoc(this.aladin, (SMoc)moc, label, c, rad, url);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanTMOC(TMoc moc, String label, String url) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        this.plan[n] = new PlanTMoc(this.aladin, moc, label, url);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanSTMOC(STMoc moc, String label, String url) {
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        Coord c = this.getTargetBG(null, null);
        double rad = this.getRadiusBG(null, null, null);
        this.plan[n] = new PlanSTMoc(this.aladin, moc, label, c, rad, url);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    public int newPlanBG(String path, String label, String target, String radius) {
        return this.newPlanBG(null, path, null, label, target, radius);
    }

    public int newPlanBG(TreeObjDir gSky, String label, String target, String radius) {
        return this.newPlanBG(gSky, null, null, label, target, radius);
    }

    public int newPlanBG(URL url, String label, String target, String radius) {
        return this.newPlanBG(null, null, url, label, target, radius);
    }

    public int newPlanBG(TreeObjDir gSky, String path, URL url, String label, String target, String radius) {
        PlanBG p;
        int n = this.getStackIndex(label);
        label = this.prepareLabel(label);
        Coord c = this.getTargetBG(target, gSky);
        double rad = this.getRadiusBG(target, radius, gSky);
        String startingTaskId = this.aladin.synchroPlan.start("Calque.newPlanBG/creating" + (label == null ? "" : "/" + label));
        if (gSky != null) {
            p = gSky.isProgen() ? new PlanBGProgen(this.aladin, gSky, label, c, rad, startingTaskId) : (gSky.isCatalog() ? new PlanBGCat(this.aladin, gSky, label, c, rad, startingTaskId) : (gSky.isMap() ? new PlanHealpix(this.aladin, gSky, label, c, rad, startingTaskId) : (gSky.isCube() ? new PlanBGCube(this.aladin, gSky, label, c, rad, startingTaskId) : new PlanBG(this.aladin, gSky, label, c, rad, startingTaskId))));
            this.plan[n] = p;
        } else {
            p = path != null ? new PlanBG(this.aladin, path, label, c, rad, startingTaskId) : new PlanBG(this.aladin, url, label, c, rad, startingTaskId);
            this.plan[n] = p;
        }
        n = this.bestPlace(n);
        this.suiteNew(p);
        return n;
    }

    private int getPlanBGRgbIndex() {
        for (int i = 0; i < this.plan.length; ++i) {
            if (!(this.plan[i] instanceof PlanBGRgb)) continue;
            return i;
        }
        return -1;
    }

    public PlanBGRgb createPlanBGRgb(TabRgb tabRgb, PlanBG red, PlanBG green, PlanBG blue) {
        String label = "HiPS RGB preview";
        int n = this.getPlanBGRgbIndex();
        if (n == -1) {
            n = this.getStackIndex(label);
        }
        label = this.prepareLabel(label);
        Coord co = new Coord(this.aladin.view.repere.raj, this.aladin.view.repere.dej);
        double coRadius = this.aladin.view.getCurrentView().getTaille();
        PlanBGRgb p = new PlanBGRgb(this.aladin, tabRgb, label, red, green, blue, co, coRadius);
        this.plan[n] = p;
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return p;
    }

    protected int newPlan(String filename, String label, String origin, Obj o) {
        return ((ServerFile)this.aladin.dialog.localServer).creatLocalPlane(filename, label, origin, o, null, null, null, null, null);
    }

    protected Plan createPlan(String filename, String label, String origin, Server server) {
        int n = ((ServerFile)this.aladin.dialog.localServer).creatLocalPlane(filename, label, origin, null, null, null, server, null, null);
        return this.plan[n];
    }

    protected int newPlan(String filename, String label, String origin) {
        return this.newPlan(filename, label, origin, null, null);
    }

    protected int newPlan(String filename, String label, String origin, String target, String radius) {
        ServerFile f = (ServerFile)this.aladin.dialog.localServer;
        label = this.prepareLabel(label);
        return f.creatLocalPlane(filename, label, origin, null, null, null, null, target, radius);
    }

    protected int newPlan(InputStream inputStream, String label, String origin) {
        return ((ServerFile)this.aladin.dialog.localServer).creatLocalPlane(null, label, origin, null, null, inputStream, null, null, null);
    }

    protected Plan createPlan(InputStream inputStream, String label, String origin) throws Exception {
        int n = ((ServerFile)this.aladin.dialog.localServer).creatLocalPlane(null, label, origin, null, null, inputStream, null, null, null);
        if (n == -2) {
            return null;
        }
        if (n < 0) {
            throw new Exception("plane creation error");
        }
        return this.plan[n];
    }

    protected Plan createPlan(InputStream inputStream, String label, String origin, Server server, URL url, String query, int requestId) throws Exception {
        int n = ((ServerFile)this.aladin.dialog.localServer).creatLocalPlane(null, label, origin, null, null, inputStream, server, null, null, url, query, requestId);
        if (n == -2) {
            return null;
        }
        if (n < 0) {
            throw new Exception("plane creation error");
        }
        return this.plan[n];
    }

    protected void newCatalogPixelExtraction() throws Exception {
        this.extractPixelAsSource(this.aladin.view.vselobj);
    }

    private void extractPixelAsSource(final Vector<Obj> v) throws Exception {
        final Plan p = this.getPlanBase();
        try {
            final AladinData cat = this.aladin.createAladinCatalog("Pixels from " + p.label);
            cat.plan.flagProcessing = true;
            this.aladin.calque.repaintAll();
            new Thread(){

                @Override
                public void run() {
                    try {
                        Calque.this.pixelExtraction(cat, p, v);
                        Calque.this.aladin.view.unSelect();
                        Calque.this.aladin.view.selectAllInPlan(cat.plan);
                    }
                    catch (Exception e1) {
                        Aladin cfr_ignored_0 = Calque.this.aladin;
                        if (Aladin.levelTrace >= 3) {
                            e1.printStackTrace();
                        }
                        cat.plan.error = "Pixel extraction error !";
                        Aladin cfr_ignored_1 = Calque.this.aladin;
                        Aladin.error(cat.plan.error);
                    }
                    finally {
                        cat.plan.flagProcessing = false;
                    }
                }
            }.start();
        }
        catch (Exception e2) {
            if (Aladin.levelTrace >= 3) {
                e2.printStackTrace();
            }
            Aladin.error("Pixel extraction error !");
        }
    }

    private void pixelExtraction(AladinData cat, Plan p, Vector<Obj> v) throws Exception {
        int nbFields = 3;
        cat.setName(new String[]{"Ra", "Dec", "Pixel"});
        cat.setDescription(new String[]{"Right Ascension (ICRS)", "Declination (ICRS)", "Pixel value"});
        cat.setDatatype(new String[]{"double", "double", "double"});
        cat.setWidth(new String[]{"15", "15", "15"});
        cat.setPrecision(new String[]{"6", "6", "5"});
        Vector<Obj> v1 = new Vector<Obj>();
        int m = 0;
        for (Obj o : v) {
            double[] triplet;
            if (!o.hasPhot() || !o.isSelected() || !o.isVisible() || (triplet = o.getStatisticsRaDecPix(p)) == null) continue;
            m += triplet.length / 3;
            v1.add(o);
        }
        boolean multiObj = v1.size() > 1;
        HashSet<Double> set = multiObj ? new HashSet<Double>() : null;
        String[] row = new String[nbFields];
        int shape = m > 10000 ? 9 : 8;
        int n = 0;
        for (Obj o : v1) {
            double[] triplet = o.getStatisticsRaDecPix(p);
            for (int i = 0; i < triplet.length; i += 3) {
                if (multiObj) {
                    double cle = triplet[i] * 1000.0 + triplet[i + 1];
                    if (n > 0 && set.contains(cle)) continue;
                    set.add(cle);
                }
                row[0] = triplet[i] + "";
                row[1] = triplet[i + 1] + "";
                row[2] = triplet[i + 2] + "";
                cat.addSource("Pix_" + m++, triplet[i], triplet[i + 1], row).setShape(shape);
            }
            ++n;
        }
        cat.objModified();
        cat.plan.flagProcessing = false;
    }

    protected void suiteNew(Plan p) {
        if (p == null) {
            return;
        }
        this.aladin.view.adjustViews(p);
        this.select.repaint();
        this.aladin.toolBox.toolMode();
    }

    protected boolean noSelected() {
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (!plan[i].selected) continue;
            return false;
        }
        return true;
    }

    private void permute(int s, int t, int n) {
        int sens;
        int n2 = sens = s < t ? 1 : -1;
        if (sens == -1) {
            ++t;
        }
        for (int i = 0; i < n; ++i) {
            int k;
            int m = sens == -1 ? t + i : t;
            Plan p = this.plan[k];
            for (k = sens == -1 ? s + i : s; k != m; k += sens) {
                this.plan[k] = this.plan[k + sens];
            }
            this.plan[m] = p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void permute(Plan source, Plan target) {
        int k = 0;
        int m = 0;
        int n = 1;
        int targetFolder = 0;
        boolean isCollapsed = this.isCollapsed(target) || target.collapse;
        targetFolder = target.folder;
        if (target.type == 11) {
            ++targetFolder;
        }
        Object object = this.pile;
        synchronized (object) {
            int i;
            Plan[] p;
            if (source.type == 11) {
                p = this.getFolderPlan(source);
                int deltaFolder = targetFolder - source.folder;
                source.folder += deltaFolder;
                for (i = 0; i < p.length; ++i) {
                    p[i].folder += deltaFolder;
                }
                n = p.length + 1;
            } else {
                source.folder = targetFolder;
            }
            for (i = 0; i < this.plan.length; ++i) {
                if (source == this.plan[i]) {
                    k = i;
                    continue;
                }
                if (target != this.plan[i]) continue;
                m = i;
            }
            this.permute(k, m, n);
            if (isCollapsed) {
                p = this.getFolderPlan(this.getFolder(target));
                for (i = 0; i < p.length; ++i) {
                    p[i].collapse = false;
                }
            }
        }
        if (source.isCatalog()) {
            PlanFilter.updatePlan(source, k, m);
            return;
        }
        if (target.isCatalog()) {
            PlanFilter.updatePlan(target, m, k);
            return;
        }
        if (source.type == 12) {
            ((PlanFilter)source).positionChange();
        }
        if (target.type == 12) {
            ((PlanFilter)target).positionChange();
        }
    }

    protected Plan getFirstCatalog() {
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].isReady() || !this.plan[i].isSimpleCatalog()) continue;
            return this.plan[i];
        }
        return null;
    }

    protected int getFirstSelected() {
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].selected) continue;
            return i;
        }
        return -1;
    }

    protected Plan getFirstSelectedPlan() {
        int n = this.getFirstSelected();
        if (n < 0) {
            return null;
        }
        return this.plan[n];
    }

    protected Plan getFirstSelectedPlanCatalog() {
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].selected || !this.plan[i].isCatalog()) continue;
            return this.plan[i];
        }
        return null;
    }

    protected PlanSTMoc getFirstSelectedorNotPlanSTMoc() {
        PlanSTMoc p = null;
        for (Plan p1 : this.plan) {
            if (!p1.isReady() || !(p1 instanceof PlanSTMoc)) continue;
            if (p1.selected) {
                return (PlanSTMoc)p1;
            }
            p = (PlanSTMoc)p1;
        }
        return p;
    }

    protected Plan getFirstSelectedorNotPlanTime() {
        Plan p = null;
        for (Plan p1 : this.plan) {
            if (!p1.isReady() || !p1.isTime()) continue;
            if (p1.selected) {
                return p1;
            }
            p = p1;
        }
        return p;
    }

    protected PlanImage getFirstSelectedPlanImage() {
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].selected || !this.plan[i].isImage() && this.plan[i].type != 16) continue;
            if (this.plan[i] instanceof PlanMultiCCD) {
                return ((PlanMultiCCD)this.plan[i]).getSelectedCCD();
            }
            return (PlanImage)this.plan[i];
        }
        return null;
    }

    protected PlanImage getFirstSelectedSimpleImage() {
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].selected || !this.plan[i].isImage()) continue;
            return (PlanImage)this.plan[i];
        }
        return null;
    }

    protected PlanImage getFirstSelectedImage() {
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].selected || !this.plan[i].isPixel()) continue;
            return (PlanImage)this.plan[i];
        }
        return null;
    }

    protected int getLastSelected() {
        for (int i = this.plan.length - 1; i >= 0; --i) {
            if (!this.plan[i].selected) continue;
            return i;
        }
        return -1;
    }

    protected Vector getSelectedPlanes() {
        Vector<Plan> v = new Vector<Plan>(10);
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (!plan[i].selected) continue;
            v.addElement(plan[i]);
        }
        return v;
    }

    protected Vector getSelectedSimpleImage() {
        Vector<Plan> v = new Vector<Plan>(10);
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (!plan[i].flagOk || !plan[i].selected || !plan[i].isSimpleImage()) continue;
            v.addElement(plan[i]);
        }
        return v;
    }

    protected Vector getSelectedImagesWithPixels() {
        Vector<Plan> v = new Vector<Plan>(10);
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            if (!plan[i].flagOk || !plan[i].selected || !plan[i].hasAvailablePixels()) continue;
            v.addElement(plan[i]);
        }
        return v;
    }

    protected void setOpacityLevelImage(float opacity) {
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            Plan p = plan[i];
            if (!p.flagOk || !p.isSimpleImage()) continue;
            p.setOpacityLevel(opacity);
        }
    }

    protected void modifyProjection(String proj) {
        Plan base = this.aladin.calque.getPlanBase();
        if (base instanceof PlanBG && base.hasSpecificProj()) {
            base.modifyProj(proj);
        } else {
            Plan[] plan = this.getPlans();
            for (int i = 0; i < plan.length; ++i) {
                if (!(plan[i] instanceof PlanBG) || plan[i].hasSpecificProj()) continue;
                plan[i].modifyProj(proj);
            }
        }
        this.aladin.view.newView();
        this.aladin.calque.repaintAll();
    }

    protected void setOpacityLevel(float opacity) {
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            Plan p = plan[i];
            if (!p.flagOk || !p.selected || !p.hasCanBeTranspState()) continue;
            p.setOpacityLevel(opacity);
            if (!((double)opacity >= 0.1)) continue;
            p.setActivated(true);
        }
    }

    protected void setScalingFactor(float scalingFactor) {
        Plan[] plan = this.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            Plan p = plan[i];
            if (!p.flagOk || !p.selected) continue;
            p.setScalingFactor(scalingFactor);
        }
    }

    protected boolean canBeTransparent(Plan p) {
        boolean isRefForVisibleView;
        if (p != null && p.hasNoPos && !p.hasXYorig) {
            p.setDebugFlag(2, false);
            return false;
        }
        boolean bl = isRefForVisibleView = p != null && p.isRefForVisibleView();
        if (p == null || p.type == 12 || !this.isFree() && isRefForVisibleView && !p.isOverlay()) {
            if (p != null) {
                p.setDebugFlag(2, false);
            }
            return false;
        }
        if (p.isOverlay()) {
            p.setDebugFlag(2, true);
            return true;
        }
        if ((p.isImage() || p.type == 16) && !this.aladin.configuration.isTransparent()) {
            return false;
        }
        if (p.type == 16 && !isRefForVisibleView && p.flagOk && !p.isUnderImg()) {
            p.setDebugFlag(2, true);
            return true;
        }
        boolean folderTrans = true;
        if (p instanceof PlanFolder) {
            Plan[] list;
            folderTrans = false;
            for (Plan p1 : list = this.getFolderPlan(p)) {
                if (!this.canBeTransparent(p1)) continue;
                folderTrans = true;
                break;
            }
        }
        if (folderTrans) {
            p.setDebugFlag(2, true);
            return true;
        }
        if (!p.flagOk || !folderTrans || !Projection.isOk(p.projd) || p.isRefForVisibleView() || p.isImage() && p.projd.isLargeField()) {
            p.setDebugFlag(2, false);
            return false;
        }
        ViewSimple vc = this.aladin.view.getCurrentView();
        Plan[] plan = this.getPlans();
        boolean audessus = true;
        for (int i = 0; i < plan.length; ++i) {
            if (audessus) {
                if (plan[i] != p) continue;
                audessus = false;
                continue;
            }
            if (!plan[i].isRefForVisibleView() || !Projection.isOk(plan[i].projd) || !plan[i].projd.agree(p.projd, vc)) continue;
            p.setDebugFlag(2, true);
            return true;
        }
        p.setDebugFlag(2, false);
        return false;
    }

    protected void addOnStack(Plan p) {
        int n = this.aladin.calque.getStackIndex();
        this.aladin.calque.plan[n] = p;
    }

    protected boolean isBGAlreadyLoaded(String id) {
        for (Plan p : this.getPlans()) {
            if (!(p instanceof PlanBG) || p.id == null || !p.id.equals(id)) continue;
            return true;
        }
        return false;
    }

    protected boolean isCSAlreadyLoaded(String id) {
        for (Plan p : this.getPlans()) {
            if (!p.isCatalog() && p instanceof PlanBG || p.id == null || !p.id.equals(id)) continue;
            return true;
        }
        return false;
    }

    private int getStackIndex() {
        return this.getStackIndex(null, 1);
    }

    private int getStackIndex(String label) {
        return this.getStackIndex(label, 1);
    }

    private int getStackIndex(String label, int nombre) {
        int i;
        if (!Calque.isNewPlan(label)) {
            int n;
            if (label.charAt(1) == '@') {
                try {
                    n = Integer.parseInt(label.substring(2));
                }
                catch (Exception e) {
                    n = -1;
                }
                n = this.plan.length - n;
            } else {
                n = this.getIndexPlan(label.substring(1), 1);
            }
            if (n >= 0) {
                if (this.plan[n].isCatalog()) {
                    this.aladin.view.deSelect(this.plan[n]);
                }
                return n;
            }
        }
        for (i = 0; i < this.plan.length && this.plan[i].type == 0; ++i) {
        }
        if (i <= nombre) {
            this.reallocPlan();
            return this.getStackIndex(null, nombre);
        }
        return --i;
    }

    public void repaintAll() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.repaintAll1();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Calque.this.repaintAll1();
                }
            });
        }
    }

    private void repaintAll1() {
        if (this.select != null) {
            this.select.repaint();
            this.zoom.zoomSliderReset();
            this.zoom.zoomView.repaint();
            this.aladin.view.repaintAll();
            this.aladin.directory.repaint();
            this.aladin.toolBox.toolMode();
        }
    }

    public void updateFootprintOpacity(float oldLevel, float newLevel) {
        for (int i = 0; i < this.plan.length; ++i) {
            if (!Aladin.isFootprintPlane(this.plan[i]) || this.plan[i].getOpacityLevel() != oldLevel) continue;
            this.plan[i].setOpacityLevel(newLevel);
        }
    }

    protected boolean hasPlanBlink(ViewSimple vs) {
        for (Plan p : this.getPlans()) {
            if (!p.isPlanBlink()) continue;
            return true;
        }
        return false;
    }
}

